package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;

public class MetaCheckBoxPropertiesAction extends DomPropertiesAction<MetaCheckBoxProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaCheckBoxProperties meta, int runType) { 
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICON, ""));
		meta.setSelectedIcon(DomHelper.readAttr(element, MetaConstants.CHECKBOX_SELECTEDICON, ""));
		meta.setIconLocation(IconLocationType.parse(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, IconLocationType.STR_LEFT)));
		meta.setHideButton(DomHelper.readAttr(element, MetaConstants.CHECKBOX_HIDEBUTTON, false));
		meta.setCheckedType(DomHelper.readAttr(element, MetaConstants.CHECKBOX_CHECKEDTYPE, ""));
		meta.setUnCheckedType(DomHelper.readAttr(element, MetaConstants.CHECKBOX_UNCHECKEDTYPE, ""));
		meta.setEnableHalfCheck(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ENABLEHALFCHECK, false));
		meta.setEnableCheckAll(DomHelper.readAttr(element, MetaConstants.CHECKBOX_ENABLECHECKALL, true));
		meta.setCheckOnClickNode(DomHelper.readAttr(element, MetaConstants.COMMON_CHECK_ON_CLICK_NODE, false));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaCheckBoxProperties meta, int runType) { 
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_HIDEBUTTON, meta.getIsHideButton(), false);
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_CHECKEDTYPE, meta.getCheckedType(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_UNCHECKEDTYPE, meta.getUnCheckedType(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ENABLEHALFCHECK, meta.getEnableHalfCheck(), false);
		DomHelper.writeAttr(element, MetaConstants.CHECKBOX_ENABLECHECKALL, meta.getEnableCheckAll(), true);
		DomHelper.writeAttr(element, MetaConstants.COMMON_CHECK_ON_CLICK_NODE, meta.getCheckOnClickNode(), false);
	}

}
