package com.bokesoft.yes.meta.persist.dom.form.component.control.listview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.editview.MetaEditViewAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaTiledList;

public class MetaTiledListAction extends MetaEditViewAction<MetaTiledList> {
	@Override
	public void load(Document document, Element element, MetaTiledList meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setCount(DomHelper.readAttr(element, MetaConstants.TILEDLIST_COUNT, MetaTiledList.TILEDLIST_DEFAULT_COUNT));
		meta.setRowGap(DomHelper.readAttr(element, MetaConstants.TILEDLIST_ROWGAP, 0));
		meta.setCellGap(DomHelper.readAttr(element, MetaConstants.TILEDLIST_CELLGAP, 0));
	}

	@Override
	public void save(Document document, Element element, MetaTiledList meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TILEDLIST_COUNT, meta.getCount(), MetaTiledList.TILEDLIST_DEFAULT_COUNT);
		DomHelper.writeAttr(element, MetaConstants.TILEDLIST_ROWGAP, meta.getRowGap(), 0);
		DomHelper.writeAttr(element, MetaConstants.TILEDLIST_CELLGAP, meta.getCellGap(), 0);
	}
}
