package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaValidateBox;

public class MetaValidateBoxAction extends MetaComponentAction<MetaValidateBox> {

	@Override
	public void load(Document document, Element element, MetaValidateBox meta, int runType) {
		super.load(document, element, meta, runType);
		String promptText = DomHelper.readAttr(element, MetaConstants.PROMPTTEXT, null);
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.VALIDATEBOX_DISABLEKEYBOARD, null));
		if(promptText != null){
			meta.setPromptText(promptText);
		}
	}
	
	@Override
	public void save(Document document, Element element, MetaValidateBox meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.PROMPTTEXT, meta.getPromptText(), "");		
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.VALIDATEBOX_DISABLEKEYBOARD, meta.isDisableKeyboard().toString(), "");
		}
	}
}
