package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTimeZoneDatePicker;

public class MetaTimeZoneDatePickerAction extends MetaComponentAction<MetaTimeZoneDatePicker> {
	
	@Override
	public void load(Document document, Element element, MetaTimeZoneDatePicker meta, int runType) {
		// TODO Auto-generated method stub
		super.load(document, element, meta, runType);
		meta.setShowTimeOff(DomHelper.readAttr(element, MetaConstants.TIMEZONE_SHOWTIMEOff, false));
	}
	
	@Override
	public void save(Document document, Element element, MetaTimeZoneDatePicker meta, int runType) {
		// TODO Auto-generated method stub
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TIMEZONE_SHOWTIMEOff, meta.isShowTimeOff(), false);
	}

}
