package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;

public class MetaTabGroupAction extends MetaComponentAction<MetaTabGroup> {
	@Override
	public void load(Document document, Element element, MetaTabGroup meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setDirection(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.TABGROUP_DIRECTION, DirectionType.STR_BOTTOM)));
		meta.setTabMode(TabMode.parse(DomHelper.readAttr(element, MetaConstants.TABGROUP_TABMODE, TabMode.STR_Fixed)));
		meta.setIndicatorHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.TABGROUP_INDICATORHEIGHT, "")));
		meta.setIndicatorColor(DomHelper.readAttr(element, MetaConstants.TABGROUP_INDICATORCOLOR, ""));
		meta.setClickAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_CLICKANIM, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaTabGroup meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TABGROUP_DIRECTION, DirectionType.toString(meta.getDirection()), DirectionType.STR_BOTTOM);
		DomHelper.writeAttr(element, MetaConstants.TABGROUP_TABMODE, TabMode.toString(meta.getTabMode()), TabMode.STR_Fixed);
		DomHelper.writeAttr(element, MetaConstants.TABGROUP_INDICATORHEIGHT, DefSize.toString(meta.getIndicatorHeight()), "");
		DomHelper.writeAttr(element, MetaConstants.TABGROUP_INDICATORCOLOR, meta.getIndicatorColor(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_CLICKANIM, meta.getClickAnim(), "");
	}
}
