package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItem;

public class MetaStateItemAction extends BaseDomAction<MetaStateItem>  {

	@Override
	public void load(Document document, Element element, MetaStateItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.STATEITEM_KEY, ""));
		meta.setText(DomHelper.readAttr(element, MetaConstants.STATEITEM_TEXT, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.STATEITEM_VALUE, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.STATEITEM_ICON, ""));
		
	}

	@Override
	public void save(Document document, Element element, MetaStateItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.STATEITEM_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.STATEITEM_KEY, meta.getText(), "");
		DomHelper.writeAttr(element, MetaConstants.STATEITEM_VALUE, meta.getText(), "");
		DomHelper.writeAttr(element, MetaConstants.STATEITEM_ICON, meta.getText(), "");
	}

}
