package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaColumnBinding;

public class MetaColumnBindingAction extends BaseDomAction<MetaColumnBinding> {

	@Override
	public void load(Document document, Element element, MetaColumnBinding meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDefaultFormulaValue(DomHelper.readAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, ""));
	}

	@Override
	public void save(Document document, Element element, MetaColumnBinding meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");
	}

}
