package com.bokesoft.yes.meta.persist.dom.flatcanvas;

import org.w3c.dom.Document;

import com.bokesoft.yes.meta.persist.dom.xml.XmlCreator;
import com.bokesoft.yes.meta.persist.dom.xml.node.Xml4jUtil;
import com.bokesoft.yes.meta.persist.dom.xml.node.XmlTree;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.xml.XmlContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCObject;

/**
 * 平面图配置文件处理
 * 
 * @author chenbinbin
 *
 */
public class MetaFlatCanvasSave {

	private AbstractMetaFCObject metaObject = null;
	
	public MetaFlatCanvasSave(AbstractMetaFCObject rootMetaObject) {
		this.metaObject = rootMetaObject;
	}
	
	/**
	 * 保存平面图配置文件
	 * 
	 * @param resolver 文件处理句柄
	 * @param resource 路径
	 */
	public void save(IMetaResolver resolver, String resource) {
		Document doc;
		try {
			doc = DomHelper.createDocument();
			IContentHandler handler = new XmlContentHandler(doc);
			metaObject.saveTo(handler, handler.getRoot());
			saveXml(doc, resolver, resource);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 将当前dom对象与源文件进行比较后保存， 保留源文件中的注释， 以及属性顺序
	 * 
	 * @param document 	配置对象
	 * @param resolver 	文件处理句柄
	 * @param resource 	文件路径
	 * @throws Exception
	 */
	private void saveXml(Document document, IMetaResolver resolver, String resource) throws Exception {
		XmlTree xmlTree = Xml4jUtil.parseTree(resource);
		XmlCreator creator = new XmlCreator(document, xmlTree);
		String xml = creator.createXml();
		byte[] bytes = xml.getBytes("UTF-8");
		resolver.write(resource, bytes);
	}
	
}
