package com.bokesoft.yes.meta.persist.dom.excel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelListItem;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateConstants;

public class MetaExcelListItemAction extends BaseDomAction<MetaExcelListItem> {

	@Override
	public void load(Document document, Element element, MetaExcelListItem meta, int runType) {
		meta.setValue(DomHelper.readAttr(element, MetaExcelTemplateConstants.LISTITEM_VALUE, ""));
		meta.setText(DomHelper.readAttr(element, MetaExcelTemplateConstants.LISTITEM_TEXT, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExcelListItem meta, int runType) {
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.LISTITEM_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaExcelTemplateConstants.LISTITEM_TEXT, meta.getText(), "");
	}
}
