package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaTable;

/**
 * 数据表对象载入和保存时的相关动作
 * 
 * @author 李姝
 * @since YES1.0
 */
public class MetaTableAction extends BaseDomAction<MetaTable> {

	@Override
	public void load(Document document, Element element, MetaTable meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setPersist(DomHelper.readAttr(element, MetaConstants.TABLE_PERSIST, true));
		meta.setTableMode(TableMode.parse(DomHelper.readAttr(element, MetaConstants.TABLE_MODE, TableMode.STR_HEAD)));
		meta.setSourceType(TableSourceType.parse(DomHelper.readAttr(element, MetaConstants.TABLE_SOURCETYPE, TableSourceType.STR_DATA_OBJECT)));
		meta.setDBTableName(DomHelper.readAttr(element, MetaConstants.TABLE_DBTABLENAME, ""));
		meta.setParentKey(DomHelper.readAttr(element, MetaConstants.TABLE_PARENT_KEY, ""));
		meta.setHidden(DomHelper.readAttr(element, MetaConstants.TABLE_HIDDEN, false));
		meta.setUniquePrimary(DomHelper.readAttr(element, MetaConstants.TABLE_UNIQUE_PRIMARY, false));
		meta.setOrderBy(DomHelper.readAttr(element, MetaConstants.TABLE_ORDERBY, ""));
		meta.setFormula(DomHelper.readAttr(element, MetaConstants.TABLE_FORMULA, ""));
		meta.setImpl(DomHelper.readAttr(element, MetaConstants.TABLE_IMPL, ""));
		meta.setLoadInMidUse(DomHelper.readAttr(element, MetaConstants.TABLE_LOAD_IN_MID_USE, true));
		meta.setLazyLoad(DomHelper.readAttr(element, MetaConstants.TABLE_LAZY_LOAD, false));
		meta.setIndexPrefix(DomHelper.readAttr(element, MetaConstants.TABLE_INDEXPREFIX, ""));
		meta.setPrimaryKey(DomHelper.readAttr(element, MetaConstants.TABLE_PRIMARYKEY, ""));
		meta.setGroupBy(DomHelper.readAttr(element, MetaConstants.TABLE_GROUPBY, ""));
		meta.setUseCursor(DomHelper.readAttr(element, MetaConstants.TABLE_USE_CURSOR, false));
		meta.setRefreshFilter(DomHelper.readAttr(element, MetaConstants.TABLE_REFRESH_FILTER, false));
		meta.setHisTableName(DomHelper.readAttr(element, MetaConstants.TABLE_HISTABLENAME, ""));
		meta.setConvertor(DomHelper.readAttr(element, MetaConstants.TABLE_CONVERTOR, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTable meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_MODE, TableMode.toString(meta.getTableMode()), TableMode.STR_HEAD);
		DomHelper.writeAttr(element, MetaConstants.TABLE_SOURCETYPE, TableSourceType.toString(meta.getSourceType()), TableSourceType.STR_DATA_OBJECT);
		DomHelper.writeAttr(element, MetaConstants.TABLE_PERSIST, meta.isPersist(), true);
		DomHelper.writeAttr(element, MetaConstants.TABLE_DBTABLENAME, meta.getDBTableName(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_PARENT_KEY, meta.getParentKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_HIDDEN, meta.isHidden(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLE_UNIQUE_PRIMARY, meta.isUniquePrimary(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLE_ORDERBY, meta.getOrderBy(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_IMPL, meta.getImpl(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_LOAD_IN_MID_USE, meta.isLoadInMidUse(), true);
		DomHelper.writeAttr(element, MetaConstants.TABLE_LAZY_LOAD, meta.isLazyLoad(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLE_INDEXPREFIX, meta.getIndexPrefix(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_PRIMARYKEY, meta.getPrimaryKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_GROUPBY, meta.getGroupBy(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_USE_CURSOR, meta.isUseCursor(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLE_REFRESH_FILTER, meta.isRefreshFilter(), false);
		DomHelper.writeAttr(element, MetaConstants.TABLE_HISTABLENAME, meta.getHisTableName(), "");
		DomHelper.writeAttr(element, MetaConstants.TABLE_CONVERTOR, meta.getConvertor(), "");
	}
}
