package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaProcess;

public class MetaProcessAction extends MetaBaseScriptAction<MetaProcess> {
	
	@Override
	public void load(Document document, Element element, MetaProcess meta, int runType) {
		super.load(document, element, meta, runType);
		MetaProcess metaProcess = (MetaProcess)meta;
		metaProcess.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaProcess meta, int runType) {
		super.save(document, element, meta, runType);
		MetaProcess metaProcess = (MetaProcess)meta;
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, metaProcess.getDescription(), "");
	}
}
