package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaEmbedTable;

public class MetaEmbedTableAction extends BaseDomAction<MetaEmbedTable> {

	@Override
	public void load(Document document, Element element, MetaEmbedTable meta, int runType) {
		meta.setObjectKey(DomHelper.readAttr(element, MetaConstants.TEMPLATE_OBJECTKEY, ""));
		meta.setTableKeys(DomHelper.readAttr(element, MetaConstants.TEMPLATE_TABLEKEYS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaEmbedTable meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TEMPLATE_OBJECTKEY, meta.getObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TEMPLATE_TABLEKEYS, meta.getTableKeys(), "");
	}

}
