package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CheckRuleScope;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRule;

public class MetaCheckRuleAction extends MetaBaseScriptAction<MetaCheckRule> {
	@Override
	public void load(Document document, Element element, MetaCheckRule meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setErrorInfo(DomHelper.readAttr(element, MetaConstants.CHECKRULE_ERRORINFO, ""));
		meta.setScope(CheckRuleScope.parse(DomHelper.readAttr(element, MetaConstants.CHECKRULE_SCOPE, CheckRuleScope.STR_MODIFIED)));
	}

	@Override
	public void save(Document document, Element element, MetaCheckRule meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.CHECKRULE_ERRORINFO, meta.getErrorInfo(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKRULE_SCOPE, CheckRuleScope.toString(meta.getScope()), CheckRuleScope.STR_MODIFIED);
	}
}
