package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTableCollection;

public class MetaTargetTableCollectionAction extends
		BaseDomAction<MetaTargetTableCollection> {

	@Override
	public void load(Document document, Element element,
			MetaTargetTableCollection meta, int runType) {
		meta.setX(DomHelper.readAttr(element, MetaMapConstants.X, -1));
		meta.setY(DomHelper.readAttr(element, MetaMapConstants.Y, -1));
		meta.setWidth(DomHelper.readAttr(element, MetaMapConstants.WIDTH, -1));
		meta.setHeight(DomHelper.readAttr(element, MetaMapConstants.HEIGHT, -1));
	}	

	@Override
	public void save(Document document, Element element,
			MetaTargetTableCollection meta, int runType) {
		DomHelper.writeAttr(element, MetaMapConstants.X, meta.getX(), -1);
		DomHelper.writeAttr(element, MetaMapConstants.Y, meta.getY(), -1);
		DomHelper.writeAttr(element, MetaMapConstants.WIDTH, meta.getWidth(), -1);
		DomHelper.writeAttr(element, MetaMapConstants.HEIGHT, meta.getHeight(), -1);
	}

}
