package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CaseType;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.RefControlType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.domain.MetaDomain;

public class MetaDomainAction extends BaseDomAction<MetaDomain> {
  
	@Override
	public void load(Document document, Element element,
			MetaDomain meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		String refControlType = DomHelper.readAttr(element, MetaConstants.DOMAIN_REFCONTROLTYPE, null);
		if(refControlType != null) {
			meta.setRefControlType(RefControlType.parse(refControlType));
		}
		String dataType = DomHelper.readAttr(element, MetaConstants.DOMAIN_DATATYPE, null);
		if(dataType != null) {
			Integer dt = DataType.parse(dataType);
			meta.setDataType(dt);
			Integer defaultLength = dt == DataType.STRING ? 255 : null;
			meta.setLength(DomHelper.readInt(element, MetaConstants.DOMAIN_LENGTH, defaultLength));
			Integer defaultPrecision = dt == DataType.NUMERIC ? 16 : null;
			meta.setPrecision(DomHelper.readInt(element, MetaConstants.DOMAIN_PRECISION, defaultPrecision));
			Integer defaultScale = dt == DataType.NUMERIC ? 2 : null;
			meta.setScale(DomHelper.readInt(element, MetaConstants.DOMAIN_SCALE, defaultScale));
		}

		String caseType = DomHelper.readAttr(element, MetaConstants.DOMAIN_CASE, null);
		if(caseType != null) {
			meta.setCase(CaseType.parse(caseType));
		}
		//下拉框
		String sourceType = DomHelper.readAttr(element, MetaConstants.DOMAIN_SOURCETYPE, null);
		if(sourceType != null) {
			meta.setSourceType(ComboBoxSourceType.parse(sourceType));
		}
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.DOMAIN_GROUPKEY, null));
		//字典
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.DOMAIN_ITEMKEY, null));
		meta.setAllowMultiSelection(DomHelper.readBool(element, MetaConstants.DOMAIN_ALLOWMULTISELECTION, null));
		meta.setCaseSensitive(DomHelper.readBool(element, MetaConstants.DOMAIN_CASESENSITIVE, null));
	}

	@Override
	public void save(Document document, Element element,
			MetaDomain meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_REFCONTROLTYPE, RefControlType.toString(meta.getRefControlType()), "");
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_DATATYPE, DataType.toString(meta.getDataType()), "");
		Integer dt = meta.getDataType() == null ? -1 : meta.getDataType();
		int length = dt == DataType.STRING ? meta.getLength() : 0;
		int defaultLength = dt == DataType.STRING ? 255 : 0;
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_LENGTH, length, defaultLength);
		if(dt == DataType.NUMERIC){
			int precision = dt == DataType.NUMERIC ? meta.getPrecision() : 0;
			element.setAttribute(MetaConstants.DOMAIN_PRECISION, Integer.toString(precision));
			int scale = dt == DataType.NUMERIC ? meta.getScale() : 0;
			element.setAttribute(MetaConstants.DOMAIN_SCALE, Integer.toString(scale));
		} else if (dt == DataType.INT || dt == DataType.LONG) {
			// 当原来是numeric类型然后转换成long/int 类型之后，原来的precision、 scale还会保留
			element.removeAttribute(MetaConstants.DOMAIN_PRECISION);
			element.removeAttribute(MetaConstants.DOMAIN_SCALE);
		}
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_CASE, CaseType.toString(meta.getCase()), null);
		//下拉框
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_SOURCETYPE, ComboBoxSourceType.format(meta.getSourceType()), "");
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_GROUPKEY, meta.getGroupKey(), "");
		//字典
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_ITEMKEY, meta.getItemKey(), null);
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_ALLOWMULTISELECTION, meta.isAllowMultiSelection(), null);
		DomHelper.writeAttr(element, MetaConstants.DOMAIN_CASESENSITIVE, meta.isCaseSensitive(), null);
	}

}
