package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.TableStatementType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaStatement;

public class MetaStatementAction extends BaseDomAction<MetaStatement> {

	@Override
	public void load(Document document, Element element, MetaStatement meta, int runType) {
		String content = DomHelper.readCDATAContent(element).trim().intern();
		meta.setContent(content);
		if ( content != null ) {
			meta.setDynamic(content.indexOf("<condition") >= 0);
		}
		meta.setDBType(DomHelper.readAttr(element, MetaConstants.DBType, ""));
		meta.setType(TableStatementType.parse(DomHelper.readAttr(element, MetaConstants.Type, TableStatementType.STR_SQL)));
	}

	@Override
	public void save(Document document, Element element, MetaStatement meta, int runType) {
		DomHelper.writeCDATAContent(document, element, meta.getContent());
		DomHelper.writeAttr(element, MetaConstants.DBType, meta.getDBType(), "");
		DomHelper.writeAttr(element, MetaConstants.Type, TableStatementType.toString(meta.getType()), TableStatementType.STR_SQL);
	}

}
