package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.type.SyncMode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaSubProcess;

public class MetaSubProcessAction extends MetaUserTaskAction<MetaSubProcess> {

	@Override
	public void load(Document doc, Element node, MetaSubProcess meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setAutoStartAction(DomHelper.readAttr(node, BPMConstants.NODE_AUTO_SUB_INSTANCE_TRIGGER, ""));
		meta.setSubProcessKey(DomHelper.readAttr(node, BPMConstants.NODE_SUB_PROCESS_KEY, ""));
		meta.setSyncMode(SyncMode.parseString(DomHelper.readAttr(node, BPMConstants.NODE_SYNC_MODE, SyncMode.STR_SYNC)));
	}

	@Override
	public void save(Document doc, Element node, MetaSubProcess meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_AUTO_SUB_INSTANCE_TRIGGER, meta.getAutoStartAction(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_SUB_PROCESS_KEY, meta.getSubProcessKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_SYNC_MODE, SyncMode.formatString(meta.getSyncMode()), SyncMode.STR_SYNC);
	}

}
