package com.bokesoft.yes.meta.persist.dom.bpm.action.message;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.message.MetaProducer;

public class MetaProducerAction extends BaseDomAction<MetaProducer> {

	@Override
	public void load(Document document, Element element, MetaProducer meta, int runType) {
		meta.setDestination(DomHelper.readAttr(element, BPMConstants.MESSAGE_DESTINATION, ""));
		meta.setMessageSendImpl(DomHelper.readAttr(element, BPMConstants.NODE_MESSAGE_SEND_IMPL, ""));
		meta.setResendTimes(DomHelper.readAttr(element, BPMConstants.MESSAGE_RESENDTIMES, 0));
		meta.setTimeout(DomHelper.readAttr(element, BPMConstants.MESSAGE_TIMEOUT, -1L));
	}
	
	@Override
	public void save(Document document, Element element, MetaProducer meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.MESSAGE_DESTINATION, meta.getDestination(), "");
		DomHelper.writeAttr(element, BPMConstants.NODE_MESSAGE_SEND_IMPL, meta.getMessageSendImpl(), "");
		DomHelper.writeAttr(element, BPMConstants.MESSAGE_RESENDTIMES, meta.getResendTimes(), 0);
		DomHelper.writeAttr(element, BPMConstants.MESSAGE_TIMEOUT, TypeConvertor.toInteger(meta.getTimeout()), -1);
	}
}
