package com.bokesoft.yes.meta.persist.dom.bpm.action.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.extend.MetaExtendItemMap;

public class MetaExtendItemMapAction extends BaseDomAction<MetaExtendItemMap> {

	@Override
	public void load(Document document, Element element, MetaExtendItemMap meta, int runType) {
		meta.setSourceKey(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_SOURCE_KEY, ""));
		meta.setExtendItemKey(DomHelper.readAttr(element, BPMConstants.PARTICIPATOR_EXTENDITEMKEY, ""));
	}
	
	@Override
	public void save(Document document, Element element, MetaExtendItemMap meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_SOURCE_KEY, meta.getSourceKey(), "");
		DomHelper.writeAttr(element, BPMConstants.PARTICIPATOR_EXTENDITEMKEY, meta.getExtendItemKey(), "");
	}
}
