package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.timer.MetaTimerItem;

public class MetaTimerItemAction extends BaseDomAction<MetaTimerItem> {

	@Override
	public void load(Document doc, Element node, MetaTimerItem meta, int runType) {
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setPeroid(DomHelper.readAttr(node, BPMConstants.TIMER_PEROID, ""));
		meta.setTrigger(DomHelper.readAttr(node, BPMConstants.TIMER_TRIGGER, ""));
		meta.setRepeat(DomHelper.readAttr(node, BPMConstants.TIMER_REPEAT, false));
		meta.setCycleInterval(DomHelper.readAttr(node, BPMConstants.TIMER_CYCLE_INTERVAL, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaTimerItem meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.TIMER_PEROID, meta.getPeroid(), "");
		DomHelper.writeAttr(node, BPMConstants.TIMER_TRIGGER, meta.getTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.TIMER_REPEAT, meta.isRepeat(), false);
		DomHelper.writeAttr(node, BPMConstants.TIMER_CYCLE_INTERVAL, meta.getCycleInterval(), "");
	}

}
