package com.bokesoft.yes.meta.persist.dom.archive;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.archive.MetaParam;

public class MetaParamAction extends BaseDomAction<MetaParam> {

	@Override
	public void load(Document document, Element element, MetaParam meta, int runType) {
		meta.setValue(DomHelper.readAttr(element, MetaArchiveConstants.VALUE, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaArchiveConstants.DATA_TYPE, DataType.STR_INT)));
		
	}

	@Override
	public void save(Document document, Element element, MetaParam meta, int runType) {
		DomHelper.writeAttr(element, MetaArchiveConstants.VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaArchiveConstants.DATA_TYPE,DataType.toString( meta.getDataType()), DataType.STR_INT);
		
	}
	
	

}
