package com.bokesoft.yes.meta.datamigration.calculate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.datamap.calculate.RefFieldMap;
import com.bokesoft.yigo.meta.datamap.source.FieldType;
import com.bokesoft.yigo.meta.datamigration.DMOpSign;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;

/**
 * 解析以后的一些迁移参数，内部实现类
 * 
 * @author 刘翔翔
 *
 */
public class MetaMigrationParas implements Serializable {

	/** 迁移发生的状态字段的条件值(整型)，通过计算statusValue而来 */
	private Integer statusIntValue = null;

	/** 迁移的主源表 */
	private String srcPrimaryTableKey = "";

	/** 迁移源单据的主表 */
	private String srcMainTableKey = "";

	/** 迁移的目标表 */
	private MetaTable targetMetaTable;

	/** 迁移源中的头表 */
	private ArrayList<MetaDMSourceTable> headList = new ArrayList<MetaDMSourceTable>();

	/** 主表的迁移配置 */
	private MetaDMSourceTable primaryDMSourceTable = null;

	/** 迁移源中的父表 */
	private ArrayList<String> parentTableList = new ArrayList<String>();

	/** 迁移源中的关联表 */
	private TreeMap<String, RefFieldMap> refTableMap = new TreeMap<String, RefFieldMap>();

	/** 迁移源的配置对象 */
	private MetaDataObject srcDataObject = null;

	/** 迁移目标的配置对象 */
	private MetaDataObject tgtDataObject = null;

	/** 迁移目标表中 数据字段的来源字段的哈希映射表 */
	private HashMap<String, MetaDMSourceField> fieldMap = new HashMap<String, MetaDMSourceField>();

	/** 负向迁移的数据字段 */
	private ArrayList<MetaColumn> negtiveDataColumnList = new ArrayList<MetaColumn>();

	/** 加减变换量的数据字段 */
	private ArrayList<MetaColumn> addDeltaColumnList = new ArrayList<MetaColumn>();
	
	/** 所有的迁移源字段 */
	private ArrayList<MetaDMSourceField> allDMSourceFields = new ArrayList<MetaDMSourceField>();

	/** 迁移的名称（用于异常信息输出） */
	private String tag = null;
	
	/** 迁移表数据源中的字段信息*/
	private MigrationDatabjectParas migrationDatabjectParas = null;
	
	private String migrationKey = null;
	
	/**
	 * 迁移参数的构造器
	 * 
	 * @param meta
	 *            需要接续的迁移配置对象
	 * @param factory
	 *            获取配置的工厂
	 * @throws Throwable
	 */
	public MetaMigrationParas(MetaDataMigration meta, IMetaFactory factory) throws Throwable {
		// 处理状态值
		srcDataObject = factory.getDataObject(meta.getSrcDataObjectKey());
		srcMainTableKey = srcDataObject.getMainTableKey();
		
		MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(factory,srcDataObject);
		if (statusCollection != null) {
			for (MetaStatus metaStatus : statusCollection) {
				if (metaStatus.getKey().equalsIgnoreCase(meta.getStatusValue()))
					statusIntValue = metaStatus.getValue();
			}
		}

		// 处理迁移目标表
		tgtDataObject = factory.getDataObject(meta.getTgtDataObjectKey());
		targetMetaTable = tgtDataObject.getTableCollection().get(0);
		migrationDatabjectParas = tgtDataObject.getMigrationDatabjectParas(factory);
		
		// 迁移字段的预处理// 移除冗余内容
		for (MetaDMSourceTable table : meta.getSourceTableCollection()) {
			boolean checkRefField = false;
			MetaTable metaTable = srcDataObject.getMetaTable(table.getTableKey());
			if (table.getIsPrimary()) {
				srcPrimaryTableKey = table.getTableKey();
				primaryDMSourceTable = table;
				searchParentTable(srcPrimaryTableKey);
			} else if (metaTable.getTableMode() == TableMode.HEAD) {
				headList.add(table);
			} else {
				checkRefField = true;
			}

			ArrayList<MetaDMSourceField> removeList = new ArrayList<MetaDMSourceField>();
			for (MetaDMSourceField field : table) {
				// 先处理关联字段
				if (checkRefField) {
					RefFieldMap rm = null;
					String refFieldKey = field.getRefFieldKey();
					if (refFieldKey != null && refFieldKey.length() > 0) {
						if (rm == null) {
							rm = new RefFieldMap(table.getTableKey());
							refTableMap.put(table.getTableKey(), rm);
						}
						rm.add(field.getDefinition(), refFieldKey);
					}
				}

				// 未设置目标字段迁移字段移除
				if (field.getTargetFieldKey() == null || field.getTargetFieldKey().length() == 0) {
					removeList.add(field);
					continue;
				}

				MetaColumn column = targetMetaTable.get(field.getTargetFieldKey());
				if (column == null) {
					throw new MetaException(MetaException.MIGRATION_TARGET_FIELD_MISS, SimpleStringFormat.format(
							StringTable.getString(null, "", StringTable.MigrationTargetFieldMiss), field.getTargetFieldKey(), targetMetaTable.getKey()));
				}

				if (column.isGroup()) {
					field.setGroupType(column.getGroupType());
				} else {
					fieldMap.put(column.getKey(), field);
					if (field.getIsNegtive())
						negtiveDataColumnList.add(column);
					if (field.getOpSign() == DMOpSign.OP_ADD_DELTA)
						addDeltaColumnList.add(column);
				}

				int dataType = column.getDataType();
				field.setTargetFieldDataType(dataType);
				if (field.getType() == FieldType.CONST) {
					field.setConstValue(ConstUtil.getValue(field.getDefinition(), dataType));
				} else if (field.getType() == FieldType.FIELD) {
					Integer srcDataType = metaTable.get(field.getDefinition()).getDataType();
					if (!srcDataType.equals(dataType)) {
						field.setNeedTypeConvert(true);
						field.setTargetFieldDataType(dataType);
					}
				} else {
					field.setNeedTypeConvert(true);
					field.setTargetFieldDataType(dataType);
				}
				field.setTableKey(table.getTableKey());
				allDMSourceFields.add(field);
			}
			for (MetaDMSourceField f : removeList) {
				table.remove(f.getKey());
			}
		}
		migrationKey = meta.getKey();
		tag = meta.getCaption() == null ? "" : meta.getCaption() + "(" + meta.getKey() + ")";
	}
	
	private void searchParentTable(String tableKey) {
		MetaTable metaTable = srcDataObject.getMetaTable(tableKey);
		if (metaTable != null) {
			String parentKey = metaTable.getParentKey();
			if (parentKey != null && parentKey.length() > 0) {
				parentTableList.add(parentKey);
				searchParentTable(parentKey);
			}
		}
	}

	public Integer getStatusIntValue() {
		return statusIntValue;
	}

	public MetaTable getTargetMetaTable() {
		return targetMetaTable;
	}

	public String getSrcPrimaryTableKey() {
		return srcPrimaryTableKey;
	}

	public String getSrcMainTableKey() {
		return srcMainTableKey;
	}

	public ArrayList<MetaDMSourceTable> getHeadList() {
		return headList;
	}

	public ArrayList<String> getParentTableList() {
		return parentTableList;
	}

	public TreeMap<String, RefFieldMap> getRefTableMap() {
		return refTableMap;
	}

	public MetaDMSourceTable getPrimaryDMSourceTable() {
		return primaryDMSourceTable;
	}

	public ArrayList<MetaColumn> getGroupColumnList() {
		return migrationDatabjectParas.getGroupColumnList();
	}

	public ArrayList<MetaColumn> getDataColumnList() {
		return migrationDatabjectParas.getDataColumnList();
	}
	
	public int getPeriodGranularity() {
		return migrationDatabjectParas.getPeriodGranularity();
	}

	public HashMap<String, MetaDMSourceField> getFieldMap() {
		return fieldMap;
	}

	public MetaDataObject getTgtDataObject() {
		return tgtDataObject;
	}

	public ArrayList<MetaColumn> getNegtiveDataColumnList() {
		return negtiveDataColumnList;
	}

	public MetaColumn getPeriodColumn() {
		return migrationDatabjectParas.getPeriodColumn();
	}

	public ArrayList<MetaColumn> getGroupColumnWithNoPeriodList() {
		return migrationDatabjectParas.getGroupColumnWithNoPeriodList();
	}

	public ArrayList<MetaColumn> getAddDeltaColumnList() {
		return addDeltaColumnList;
	}

	public String getPeriodImpl() {
		return migrationDatabjectParas.getPeriodImpl();
	}

	public String getTag() {
		return tag;
	}
	
	public String getMigrationKey() {
		return migrationKey;
	}
	
	public List<MetaDMSourceField> getAllDMSourceFields() {
		return allDMSourceFields;
	}
	
	public MetaTable getSourceMainMetaTable() {
		return srcDataObject.getMainTable();
	}
	
	public MetaDataObject getSourceDataObject() {
		return srcDataObject;
	}
	
	public String getPeriodBeginColumn(MetaColumn column) {
		MetaColumn begin = migrationDatabjectParas.getPeriodBeginColumn(column.getKey());
		return begin.getBindingDBColumnName();
	}
	
	public String getPeriodEndColumn(MetaColumn column) {
		MetaColumn end = migrationDatabjectParas.getPeriodEndColumn(column.getKey());
		return end.getBindingDBColumnName();
	}
	
	public MetaColumn getDataFieldByPeriodEndField(MetaColumn column) {
		MetaColumn dataFieldColumn = migrationDatabjectParas.getDataFieldByPeriodEndField(column.getKey());
		return dataFieldColumn;
	}
}
