/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.rights;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.rights.MetaDictDefinition;
import com.bokesoft.yigo.meta.rights.MetaDictRightsCollection;
import com.bokesoft.yigo.meta.rights.MetaFormDefinition;
import com.bokesoft.yigo.meta.rights.MetaFormRightsCollection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public class MetaRightsDefinition
extends AbstractMetaObject
implements IElementMerge<MetaRightsDefinition> {
    private MetaFormRightsCollection formRights = null;
    private MetaDictRightsCollection dictRights = null;
    private Boolean allRights = false;
    private Set<String> differentSolutionKeys;
    private MetaFormRightsCollection differentFormRights = null;
    private MetaDictRightsCollection differentDictRights = null;
    private Set<String> differentFormKeys;
    private Set<String> differentItemKeys;
    public static final String TAG_NAME = "RightsDefinition";

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        if (this.formRights != null) {
            list.add(this.formRights);
        }
        if (this.dictRights != null) {
            list.add(this.dictRights);
        }
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        GenericNoKeyCollection resultMetaObject = null;
        if ("FormRightsCollection".equals(tagName)) {
            resultMetaObject = this.formRights = new MetaFormRightsCollection();
        } else if ("DictRightsCollection".equals(tagName)) {
            this.dictRights = new MetaDictRightsCollection();
            resultMetaObject = this.dictRights;
        }
        return resultMetaObject;
    }

    public Boolean isAllRights() {
        return this.allRights;
    }

    public void setAllRights(Boolean allRights) {
        this.allRights = allRights;
    }

    public MetaFormRightsCollection getFormRightsCollection() {
        return this.formRights;
    }

    public void setFormRightsCollection(MetaFormRightsCollection formRightsCollection) {
        this.formRights = formRightsCollection;
    }

    public MetaDictRightsCollection getDictRightsCollection() {
        return this.dictRights;
    }

    public void setDictRightsCollection(MetaDictRightsCollection dictRightsCollection) {
        this.dictRights = dictRightsCollection;
    }

    @Override
    public AbstractMetaObject clone() {
        return null;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaRightsDefinition();
    }

    public boolean hasAllFormRights(String formKey) {
        return this.hasAllFormRights(formKey, null);
    }

    public boolean hasAllFormRights(String formKey, String solutionKey) {
        if (solutionKey != null && this.differentSolutionKeys != null && this.differentSolutionKeys.contains(solutionKey) || this.differentFormKeys != null && this.differentFormKeys.contains(formKey)) {
            return this.innerHasAllFormRights(formKey, this.allRights == false, this.differentFormRights);
        }
        return this.innerHasAllFormRights(formKey, this.allRights, this.formRights);
    }

    private boolean innerHasAllFormRights(String formKey, boolean allRights, MetaFormRightsCollection formRights) {
        if (allRights) {
            return formRights == null ? false : formRights.contains(formKey);
        }
        return formRights == null ? true : !formRights.contains(formKey);
    }

    public boolean hasAllDictRights(String itemKey) {
        return this.hasAllDictRights(itemKey, null);
    }

    public boolean hasAllDictRights(String itemKey, String solutionKey) {
        if (solutionKey != null && this.differentSolutionKeys != null && this.differentSolutionKeys.contains(solutionKey) || this.differentItemKeys != null && this.differentItemKeys.contains(itemKey)) {
            return this.innerHasAllDictRights(itemKey, this.allRights == false, this.differentDictRights);
        }
        return this.innerHasAllDictRights(itemKey, this.allRights, this.dictRights);
    }

    private boolean innerHasAllDictRights(String itemKey, boolean allRights, MetaDictRightsCollection dictRights) {
        if (allRights) {
            return dictRights == null ? false : dictRights.contains(itemKey);
        }
        return dictRights == null ? true : !dictRights.contains(itemKey);
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        if (this.formRights != null) {
            this.formRights.doPostProcess(flag, callback);
        }
        if (this.dictRights != null) {
            this.dictRights.doPostProcess(flag, callback);
        }
        if (this.differentFormRights != null) {
            this.differentFormRights.doPostProcess(flag, callback);
        }
        if (this.differentDictRights != null) {
            this.differentDictRights.doPostProcess(flag, callback);
        }
    }

    @Override
    public MetaRightsDefinition toMerge(MetaRightsDefinition obj) {
        return this.toMerge(obj, null);
    }

    public MetaRightsDefinition toMerge(MetaRightsDefinition obj, String solutionKey) {
        if (obj != null) {
            if (this.allRights != obj.allRights) {
                if (this.differentSolutionKeys == null) {
                    this.differentSolutionKeys = new HashSet<String>();
                }
                this.differentSolutionKeys.add(solutionKey);
                if (this.differentFormRights == null) {
                    this.differentFormRights = new MetaFormRightsCollection();
                }
                this.differentFormRights.toMerge(obj.formRights);
                if (this.differentDictRights == null) {
                    this.differentDictRights = new MetaDictRightsCollection();
                }
                this.differentDictRights.toMerge(obj.dictRights);
            } else {
                if (this.formRights == null) {
                    this.formRights = new MetaFormRightsCollection();
                }
                this.formRights.toMerge(obj.formRights);
                if (this.dictRights == null) {
                    this.dictRights = new MetaDictRightsCollection();
                }
                this.dictRights.toMerge(obj.dictRights);
            }
        }
        return this;
    }

    public void addFormRights(String formKey) {
        this.addFormRights(formKey, this.allRights);
    }

    public void addFormRights(String formKey, boolean allRights) {
        if (allRights == this.allRights) {
            if (this.formRights == null) {
                this.formRights = new MetaFormRightsCollection();
            }
            this.innerAddFormRights(formKey, this.formRights);
        } else {
            if (this.differentFormKeys == null) {
                this.differentFormKeys = new HashSet<String>();
            }
            this.differentFormKeys.add(formKey);
            if (this.differentFormRights == null) {
                this.differentFormRights = new MetaFormRightsCollection();
            }
            this.innerAddFormRights(formKey, this.differentFormRights);
        }
    }

    private void innerAddFormRights(String formKey, MetaFormRightsCollection formRights) {
        if (formRights.contains(formKey)) {
            return;
        }
        MetaFormDefinition formDefinition = new MetaFormDefinition();
        formDefinition.setFormKey(formKey);
        formRights.add(formDefinition);
    }

    public void removeFormRights(String formKey) {
        if (this.differentFormKeys != null && this.differentFormKeys.contains(formKey)) {
            this.innerRemoveFormRights(formKey, this.differentFormRights);
            this.differentFormKeys.remove(formKey);
        } else if (!this.innerRemoveFormRights(formKey, this.formRights)) {
            this.innerRemoveFormRights(formKey, this.differentFormRights);
        }
    }

    private boolean innerRemoveFormRights(String formKey, MetaFormRightsCollection formRights) {
        if (formRights == null) {
            return false;
        }
        int size = formRights.size();
        for (int i = 0; i < size; ++i) {
            MetaFormDefinition formDefinition = (MetaFormDefinition)formRights.get(i);
            if (!Objects.equals(formDefinition.getFormKey(), formKey)) continue;
            formRights.remove(i);
            return true;
        }
        return false;
    }

    public void addDictRights(String itemKey) {
        this.addDictRights(itemKey, this.allRights);
    }

    public void addDictRights(String itemKey, boolean allRights) {
        if (allRights == this.allRights) {
            if (this.dictRights == null) {
                this.dictRights = new MetaDictRightsCollection();
            }
            this.innerAddDictRights(itemKey, this.dictRights);
        } else {
            if (this.differentItemKeys == null) {
                this.differentItemKeys = new HashSet<String>();
            }
            this.differentItemKeys.add(itemKey);
            if (this.differentDictRights == null) {
                this.differentDictRights = new MetaDictRightsCollection();
            }
            this.innerAddDictRights(itemKey, this.differentDictRights);
        }
    }

    private void innerAddDictRights(String itemKey, MetaDictRightsCollection dictRights) {
        if (dictRights.contains(itemKey)) {
            return;
        }
        MetaDictDefinition dictDefinition = new MetaDictDefinition();
        dictDefinition.setItemKey(itemKey);
        dictRights.add(dictDefinition);
    }

    public void removeDictRights(String itemKey) {
        if (this.differentItemKeys != null && this.differentItemKeys.contains(itemKey)) {
            this.innerRemoveDictRights(itemKey, this.differentDictRights);
            this.differentItemKeys.remove(itemKey);
        } else if (!this.innerRemoveDictRights(itemKey, this.dictRights)) {
            this.innerRemoveDictRights(itemKey, this.differentDictRights);
        }
    }

    private boolean innerRemoveDictRights(String itemKey, MetaDictRightsCollection dictRights) {
        if (dictRights == null) {
            return false;
        }
        int size = dictRights.size();
        for (int i = 0; i < size; ++i) {
            MetaDictDefinition dictDefinition = (MetaDictDefinition)dictRights.get(i);
            if (!Objects.equals(dictDefinition.getItemKey(), itemKey)) continue;
            dictRights.remove(i);
            return true;
        }
        return false;
    }
}

