/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.panel;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class MetaPanel
extends MetaComponent {
    protected StringHashMap<MetaComponent> componentMap = null;
    protected ArrayList<MetaComponent> componentArray = new ArrayList();
    private Integer overflowX = 0;
    private Integer overflowY = 0;
    private String backImage = "";
    private Integer backImagePosition = -1;
    private Boolean backImageRepeatX = false;
    private Boolean backImageRepeatY = false;
    private Integer backImageScaleType = -1;
    private String layoutAnim = "";
    private MetaBaseScript check = null;
    private MetaBaseScript leave = null;

    public MetaPanel() {
        this.componentMap = new StringHashMap();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        list.add(this.componentArray);
        if (this.check != null) {
            list.add(this.check);
        } else if (this.leave != null) {
            list.add(this.leave);
        }
    }

    @Override
    public abstract String getTagName();

    public abstract MetaComponentLayout<?> newLayout();

    public MetaBaseScript getCheck() {
        return this.check;
    }

    public void setCheck(MetaBaseScript check) {
        this.check = check;
    }

    public MetaBaseScript getLeave() {
        return this.leave;
    }

    public void setLeave(MetaBaseScript leave) {
        this.leave = leave;
    }

    @Override
    public boolean receiveFocus() {
        return false;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject obj = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if (obj != null) {
            return obj;
        }
        MetaBaseScript resultMetaObject = null;
        if ("Check".equals(tagName)) {
            resultMetaObject = this.check = new MetaBaseScript("Check");
        } else if ("Leave".equals(tagName)) {
            resultMetaObject = this.leave = new MetaBaseScript("Leave");
        }
        if (resultMetaObject != null) {
            return resultMetaObject;
        }
        MetaComponent control = MetaComponentFactory.getInstance().newComponent(tagName);
        control.preProcessMetaObject(env, doc, node, flag, runType);
        this.addComponent(control);
        return control;
    }

    @Override
    public void addComponent(MetaComponent component) {
        if (Objects.isNull(component) || this.componentArray.contains(component)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)component.getKey()) && this.componentMap.containsKey((Object)component.getKey())) {
            return;
        }
        this.componentArray.add(component);
        this.componentMap.put((Object)component.getKey(), (Object)component);
    }

    public void addComponent(int index, MetaComponent component) {
        if (Objects.isNull(component) || this.componentArray.contains(component)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)component.getKey()) && this.componentMap.containsKey((Object)component.getKey())) {
            return;
        }
        if (index < 0) {
            this.componentArray.add(0, component);
        } else if (index > this.componentArray.size() - 1) {
            this.componentArray.add(component);
        } else {
            this.componentArray.add(index, component);
        }
        this.componentMap.put((Object)component.getKey(), (Object)component);
    }

    @Override
    public int getComponentCount() {
        return this.componentArray.size();
    }

    public void clear() {
        this.componentArray.clear();
        this.componentMap.clear();
    }

    @Override
    public MetaComponent getComponent(int index) {
        return this.componentArray.get(index);
    }

    public MetaComponent getComponent(String key) {
        return (MetaComponent)this.componentMap.get((Object)key);
    }

    public boolean containsComponent(String key) {
        return this.componentMap.containsKey((Object)key);
    }

    public Iterator<MetaComponent> iteratorComponent() {
        return this.componentArray.iterator();
    }

    public ArrayList<MetaComponent> getComponentArray() {
        return this.componentArray;
    }

    public void setComponentArray(ArrayList<MetaComponent> componentArray) {
        this.componentArray = componentArray;
    }

    public void setOverflowX(Integer overflowX) {
        this.overflowX = overflowX;
    }

    public Integer getOverflowX() {
        return this.overflowX;
    }

    public void setOverflowY(Integer overflowY) {
        this.overflowY = overflowY;
    }

    public Integer getOverflowY() {
        return this.overflowY;
    }

    public void setBackImage(String backImage) {
        this.backImage = backImage;
    }

    public String getBackImage() {
        return this.backImage;
    }

    public void setBackImagePosition(Integer backImagePosition) {
        this.backImagePosition = backImagePosition;
    }

    public Integer getBackImagePosition() {
        return this.backImagePosition;
    }

    public void setBackImageRepeatX(Boolean backImageRepeatX) {
        this.backImageRepeatX = backImageRepeatX;
    }

    public Boolean isBackImageRepeatX() {
        return this.backImageRepeatX;
    }

    public void setBackImageRepeatY(Boolean backImageRepeatY) {
        this.backImageRepeatY = backImageRepeatY;
    }

    public Boolean isBackImageRepeatY() {
        return this.backImageRepeatY;
    }

    public void setBackImageScaleType(Integer backImageScaleType) {
        this.backImageScaleType = backImageScaleType;
    }

    public Integer getBackImageScaleType() {
        return this.backImageScaleType;
    }

    public void setLayoutAnim(String layoutAnim) {
        this.layoutAnim = layoutAnim;
    }

    public String getLayoutAnim() {
        return this.layoutAnim;
    }

    @Override
    public boolean isPanel() {
        return true;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaPanel newObject = (MetaPanel)super.clone();
        if (this.componentArray != null) {
            Iterator<MetaComponent> it = this.componentArray.iterator();
            MetaComponent metaComponent = null;
            while (it.hasNext()) {
                metaComponent = it.next();
                MetaComponent newMetaComponent = (MetaComponent)metaComponent.clone();
                newObject.addComponent(newMetaComponent);
            }
        }
        newObject.setOverflowX(this.overflowX);
        newObject.setOverflowY(this.overflowY);
        newObject.setBackImage(this.backImage);
        newObject.setBackImagePosition(this.backImagePosition);
        newObject.setBackImageRepeatX(this.backImageRepeatX);
        newObject.setBackImageRepeatY(this.backImageRepeatY);
        newObject.setBackImageScaleType(this.backImageScaleType);
        newObject.setLayoutAnim(this.layoutAnim);
        return newObject;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        Iterator<MetaComponent> it = this.componentArray.iterator();
        MetaComponent metaComponent = null;
        while (it.hasNext()) {
            metaComponent = it.next();
            metaComponent.doPostProcess(flag, callback);
        }
    }

    public void removeComponent(MetaComponent component) {
        this.componentArray.remove(component);
        this.componentMap.remove((Object)component.getKey());
    }

    public void removeComponent(String key) {
        MetaComponent comp = (MetaComponent)this.componentMap.get((Object)key);
        this.componentArray.remove(comp);
        this.componentMap.remove((Object)key);
    }

    @Override
    public void merge(MetaComponent meta) {
        super.merge(meta);
        MetaPanel metaPanel = (MetaPanel)meta;
        if (this.overflowX == -1) {
            this.overflowX = metaPanel.getOverflowX();
        }
        if (this.overflowY == -1) {
            this.overflowY = metaPanel.getOverflowY();
        }
        if (this.backImage == null) {
            this.backImage = metaPanel.getBackImage();
        }
        if (this.backImagePosition == -1) {
            this.backImagePosition = metaPanel.getBackImagePosition();
        }
        if (this.backImageRepeatX == null) {
            this.backImageRepeatX = metaPanel.isBackImageRepeatX();
        }
        if (this.backImageRepeatY == null) {
            this.backImageRepeatY = metaPanel.isBackImageRepeatY();
        }
        if (this.backImageScaleType == -1) {
            this.backImageScaleType = metaPanel.getBackImageScaleType();
        }
        if (this.layoutAnim == null) {
            this.layoutAnim = metaPanel.getLayoutAnim();
        }
    }
}

