/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.control.properties;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import java.util.LinkedList;

public class MetaSliderProperties
extends AbstractMetaObject
implements IPropertyMerger<MetaSliderProperties> {
    public static final int DEFAULT_MAX_POS = 100;
    public static final String DEFAULT_BAR_COLOR = "#dddddd";
    public static final String DEFAULT_PROGRESS_COLOR = "#00aaee";
    private Integer maxPos = 100;
    private Integer minPos = 0;
    private Integer stepValue = 0;
    private String barColor = "#dddddd";
    private String progressColor = "#00aaee";
    private Boolean isAllowMultiSelection = false;

    public String getBarColor() {
        return this.barColor;
    }

    public void setBarColor(String barColor) {
        this.barColor = barColor;
    }

    public String getProgressColor() {
        return this.progressColor;
    }

    public void setProgressColor(String progressColor) {
        this.progressColor = progressColor;
    }

    public Integer getMaxPos() {
        return this.maxPos;
    }

    public void setMaxPos(Integer maxPos) {
        this.maxPos = maxPos;
    }

    public Integer getMinPos() {
        return this.minPos;
    }

    public void setMinPos(Integer minPos) {
        this.minPos = minPos;
    }

    public Integer getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(Integer stepValue) {
        this.stepValue = stepValue;
    }

    public Boolean isAllowMultiSelection() {
        return this.isAllowMultiSelection;
    }

    public void setAllowMultiSelection(Boolean allowMultiSelection) {
        this.isAllowMultiSelection = allowMultiSelection;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if (this.maxPos <= this.minPos) {
            throw new MetaException(128, SimpleStringFormat.format((String)StringTable.getString(null, "", "ComponentMaxNotGreaterThanMin"), (Object[])new Object[]{"Slider"}));
        }
        if (this.stepValue < 0) {
            throw new MetaException(129, SimpleStringFormat.format((String)StringTable.getString(null, "", "ComponentStepLessThanZero"), (Object[])new Object[]{"Slider"}));
        }
        if (this.stepValue > 0 && (this.maxPos - this.minPos) % this.stepValue != 0) {
            throw new MetaException(130, SimpleStringFormat.format((String)StringTable.getString(null, "", "ComponentRangeCannotBeDividedByStep"), (Object[])new Object[]{"Slider"}));
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        return null;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaSliderProperties newObj = (MetaSliderProperties)this.newInstance();
        newObj.setMaxPos(this.maxPos);
        newObj.setMinPos(this.minPos);
        newObj.setStepValue(this.stepValue);
        newObj.setBarColor(this.barColor);
        newObj.setProgressColor(this.progressColor);
        newObj.setAllowMultiSelection(this.isAllowMultiSelection);
        return newObj;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaSliderProperties();
    }

    @Override
    public void merge(MetaSliderProperties properties) {
        if (this.maxPos == null) {
            this.maxPos = properties.getMaxPos();
        }
        if (this.minPos == null) {
            this.minPos = properties.getMinPos();
        }
        if (this.stepValue == null) {
            this.stepValue = properties.getStepValue();
        }
        if (this.barColor == null) {
            this.barColor = properties.getBarColor();
        }
        if (this.progressColor == null) {
            this.progressColor = properties.getProgressColor();
        }
        if (this.isAllowMultiSelection == null) {
            this.isAllowMultiSelection = properties.isAllowMultiSelection();
        }
    }
}

