/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.control.properties;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class MetaCheckListBoxProperties
extends AbstractMetaObject
implements IPropertyMerger<MetaCheckListBoxProperties> {
    public static final int DEFAULT_COLUMN_COUNT = 3;
    private MetaListBoxItemCollection items = null;
    private MetaBaseScript formulaItems = null;
    private String itemsDependency = "";
    private Boolean cache = true;
    private List<String> dependentFields = new ArrayList<String>();
    private MetaQueryDef query = null;
    private Integer sourceType = 0;
    private String groupKey = "";
    private String globalItems = "";
    private String promptText = "";
    private Integer style = 0;
    private Integer editType = 1;
    private Integer columnCount = 3;
    private String popAnim = "";
    private String cssClass = "";
    private Integer textShowType = -1;
    private MetaComboFilter comboFilter = null;

    public String getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public MetaCheckListBoxProperties() {
        this.items = new MetaListBoxItemCollection();
    }

    public List<String> getDependedFields() {
        return this.dependentFields;
    }

    public String getItemsDependency() {
        return this.itemsDependency;
    }

    public boolean isDynamicBehavior() {
        return this.dependentFields.size() > 0;
    }

    public String getGlobalItems() {
        return this.globalItems;
    }

    public void setGlobalItems(String globalItems) {
        this.globalItems = globalItems;
    }

    public void setItemsDependency(String dependency) {
        this.itemsDependency = "";
        this.dependentFields.clear();
        if (dependency != null && dependency.length() > 0) {
            String[] fields;
            this.itemsDependency = dependency;
            for (String field : fields = this.itemsDependency.split(",")) {
                this.dependentFields.add(field);
            }
        }
    }

    public void setDependentFields(List<String> dependentFields) {
        this.dependentFields = dependentFields;
    }

    public void setFormulaItems(MetaBaseScript formulaItems) {
        this.formulaItems = formulaItems;
    }

    public MetaBaseScript getFormulaItems() {
        return this.formulaItems;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void setPromptText(String promptText) {
        this.promptText = promptText;
    }

    public String getPromptText() {
        return this.promptText;
    }

    public Integer getStyle() {
        return this.style;
    }

    public void setStyle(Integer style) {
        this.style = style;
    }

    public Integer getEditType() {
        return this.editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    public MetaDefaultItem getItem(int index) {
        return (MetaDefaultItem)this.items.get(index);
    }

    public void setItems(MetaListBoxItemCollection items) {
        this.items = items;
    }

    public void setQueryDef(MetaQueryDef query) {
        this.query = query;
    }

    public MetaQueryDef getQueryDef() {
        return this.query;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Integer type) {
        this.sourceType = type;
    }

    public MetaListBoxItemCollection getItems() {
        return this.items;
    }

    public String getPopAnim() {
        return this.popAnim;
    }

    public void setPopAnim(String popAnim) {
        this.popAnim = popAnim;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public Integer getTextShowType() {
        return this.textShowType;
    }

    public void setTextShowType(Integer type) {
        this.textShowType = type;
    }

    public String getTextShowFormat() {
        return ComboBoxTextShowType.getFormatString((int)this.getTextShowType());
    }

    public MetaComboFilter getComboFilter() {
        return this.comboFilter;
    }

    public void setComboFilter(MetaComboFilter comboFilter) {
        this.comboFilter = comboFilter;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        this.addAll(list, new AbstractMetaObject[]{this.items, this.formulaItems, this.query, this.comboFilter});
    }

    @Override
    public String getTagName() {
        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        if (this.query != null) {
            this.query.doPostProcess(flag, callback);
            List<String> list = this.query.getDependedFields();
            if (list != null) {
                for (String field : list) {
                    if (this.dependentFields.contains(field)) continue;
                    this.dependentFields.add(field);
                }
            }
        }
        if (this.comboFilter != null) {
            this.comboFilter.doPostProcess(flag, callback);
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = this.items.createChildMetaObject(env, doc, node, tagName, flag, runType);
        if (resultMetaObject == null) {
            if (tagName.equalsIgnoreCase("FormulaItems")) {
                this.formulaItems = new MetaBaseScript("FormulaItems");
                resultMetaObject = this.formulaItems;
            } else if (tagName.equalsIgnoreCase("QueryDef")) {
                this.query = new MetaQueryDef();
                resultMetaObject = this.query;
            } else if (tagName.equalsIgnoreCase("ComboFilter")) {
                this.comboFilter = new MetaComboFilter();
                resultMetaObject = this.comboFilter;
            }
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaCheckListBoxProperties newObject = new MetaCheckListBoxProperties();
        newObject.setItems(this.items == null ? null : (MetaListBoxItemCollection)this.items.clone());
        newObject.setFormulaItems(this.formulaItems == null ? null : (MetaBaseScript)this.formulaItems.clone());
        newObject.setItemsDependency(this.itemsDependency);
        newObject.setQueryDef(this.query == null ? null : (MetaQueryDef)this.query.clone());
        newObject.setSourceType(this.sourceType);
        newObject.setGroupKey(this.groupKey);
        newObject.setGlobalItems(this.globalItems);
        newObject.setDependentFields(this.dependentFields);
        newObject.setPromptText(this.promptText);
        newObject.setStyle(this.style);
        newObject.setEditType(this.editType);
        newObject.setCache(this.cache);
        newObject.setColumnCount(this.columnCount);
        newObject.setPopAnim(this.popAnim);
        newObject.setCssClass(this.cssClass);
        newObject.setTextShowType(this.textShowType);
        newObject.setComboFilter(this.comboFilter == null ? null : (MetaComboFilter)this.comboFilter.clone());
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaCheckListBoxProperties();
    }

    @Override
    public void merge(MetaCheckListBoxProperties properties) {
        MetaComboFilter comboFilter;
        if (Objects.nonNull(properties.getItems())) {
            MetaListBoxItemCollection items = (MetaListBoxItemCollection)properties.getItems().clone();
            if (Objects.nonNull(this.items)) {
                ArrayList<String> existItemKeys = new ArrayList<String>();
                for (MetaDefaultItem item : items) {
                    existItemKeys.add(item.getKey());
                }
                for (MetaDefaultItem item : this.items) {
                    if (existItemKeys.contains(item.getKey())) continue;
                    items.add((MetaDefaultItem)item.clone());
                }
            }
            this.items = (MetaListBoxItemCollection)items.clone();
        }
        if (this.formulaItems == null) {
            this.formulaItems = properties.getFormulaItems();
        }
        if (this.query == null) {
            this.query = properties.getQueryDef();
        }
        if (this.itemsDependency == null) {
            this.itemsDependency = properties.getItemsDependency();
        }
        if (this.sourceType == -1) {
            this.sourceType = properties.getSourceType();
        }
        if (this.cache == null) {
            this.cache = properties.getCache();
        }
        if (this.groupKey == null) {
            this.groupKey = properties.getGroupKey();
        }
        if (this.globalItems == null) {
            this.globalItems = properties.getGlobalItems();
        }
        if (this.cssClass == null) {
            this.cssClass = properties.getCssClass();
        }
        if (this.textShowType == -1) {
            this.textShowType = properties.getTextShowType();
        }
        if ((comboFilter = properties.getComboFilter()) != null) {
            if (this.comboFilter == null) {
                this.comboFilter = (MetaComboFilter)comboFilter.clone();
            } else {
                this.comboFilter.merge(comboFilter);
            }
        }
    }
}

