/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.flatcanvas.util;

import com.bokesoft.yigo.meta.flatcanvas.convertor.xml.XmlContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.node.AbstractMetaFCObject;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCPaper;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCSection;
import com.bokesoft.yigo.meta.flatcanvas.node.MetaFCSectionCollection;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FCDomUtil {
    public static MetaFCSectionCollection loadSectionCollection(File file) {
        MetaFCSectionCollection sectionModels = new MetaFCSectionCollection();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            Element elem = doc.getDocumentElement();
            sectionModels.loadFromElement(elem);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sectionModels;
    }

    public static MetaFCPaper loadPaper(File file) {
        MetaFCPaper paperModel = new MetaFCPaper();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            Element elem = doc.getDocumentElement();
            paperModel.loadFromElement(elem);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return paperModel;
    }

    public static void save(MetaFCPaper paperModel, File file) {
        try {
            DocumentBuilder dombuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dombuilder.newDocument();
            XmlContentHandler handler = new XmlContentHandler(doc);
            paperModel.saveTo(handler, handler.getRoot());
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, new StreamResult(file));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static String model2String(AbstractMetaFCObject fcMeta) {
        try {
            DocumentBuilder dombuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dombuilder.newDocument();
            XmlContentHandler handler = new XmlContentHandler(doc);
            fcMeta.saveTo(handler, handler.getRoot());
            StringWriter sw = new StringWriter();
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, new StreamResult(sw));
            return sw.toString();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return "";
    }

    public static AbstractMetaFCObject string2Model(String sXmlStr) {
        MetaFCSection sectionModel = new MetaFCSection();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            StringReader sr = new StringReader(sXmlStr);
            InputSource is = new InputSource(sr);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            Element elem = doc.getDocumentElement();
            sectionModel.loadFromElement(elem);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sectionModel;
    }
}

