/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory;

import com.bokesoft.yigo.meta.base.IConfigResolver;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

public class DefaultResourceResolver
implements IMetaResolver {
    private IConfigResolver configResolver;
    private String parentPath = null;
    private String prefix = null;

    public DefaultResourceResolver(IConfigResolver configResolver, String parentPath, String prefix) {
        this.configResolver = configResolver;
        this.parentPath = parentPath;
        this.prefix = prefix;
    }

    @Override
    public boolean isListAbsolutePath() {
        return false;
    }

    @Override
    public InputStream read(String resource, int type) throws Exception {
        return this.configResolver.read(this.parentPath, this.prefix, resource, type);
    }

    @Override
    public URI getURI(String resource, int type) throws Exception {
        File f = new File(this.configResolver.getPath(this.parentPath, this.prefix, resource));
        if (f.isDirectory() || !f.exists()) {
            return null;
        }
        return f.toURI();
    }

    @Override
    public boolean write(String resource, byte[] data) throws Exception {
        return this.configResolver.write(this.parentPath, this.prefix, resource, data);
    }

    @Override
    public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
        return this.configResolver.listResource(this.parentPath, this.prefix, resource, flag, resources, names, flags);
    }

    @Override
    public String getPath(String resource) {
        return this.configResolver.getPath(this.parentPath, this.prefix, resource);
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }
}

