/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.archive;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.archive.MetaArchiveObject;
import com.bokesoft.yigo.meta.archive.MetaArchiveRule;
import com.bokesoft.yigo.meta.archive.MetaFieldCollection;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MetaArchiveRuleGroup
extends GenericKeyCollectionWithKey<MetaArchiveRule> {
    public static final String TAG_NAME = "RuleGroup";
    private String key = "";
    private Map<String, MetaArchiveRule> objRuleMap = new HashMap<String, MetaArchiveRule>();

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaArchiveRule child = null;
        if ("ArchiveRule".equalsIgnoreCase(tagName)) {
            MetaArchiveRule rule = new MetaArchiveRule();
            rule.preProcessMetaObject(env, doc, node, flag, runType);
            this.add(rule);
            child = rule;
        }
        return child;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaArchiveRuleGroup();
    }

    @Override
    public AbstractMetaObject clone() {
        MetaArchiveRuleGroup newObj = (MetaArchiveRuleGroup)super.clone();
        newObj.key = this.key;
        return newObj;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        this.objRuleMap.clear();
        for (MetaArchiveRule rule : this) {
            for (MetaArchiveObject obj : rule.getObjectCollection()) {
                this.objRuleMap.put(obj.getKey(), rule);
            }
        }
    }

    public MetaArchiveRule getObjRule(String objKey) {
        return this.objRuleMap.get(objKey);
    }

    public Map<String, MetaArchiveRule> getObjRuleMap() {
        return this.objRuleMap;
    }

    public MetaFieldCollection getObjCondition(String objKey) {
        MetaArchiveRule rule = this.objRuleMap.get(objKey);
        return rule.getFieldCollection();
    }
}

