/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.process;

import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import java.util.HashMap;
import java.util.HashSet;

public class MetaDataObjectTemplateUtil {
    private MetaDataObject targetDataObject = null;
    private MetaDataObject sourceDataObject = null;
    private String tableKeys = "";
    private HashSet<String> sourceTables = null;
    private HashMap<String, Object> vars = null;

    public MetaDataObjectTemplateUtil(MetaDataObject sourceDataObject, MetaDataObject targetDataObject, String tableKeys, HashMap<String, Object> vars) throws Exception {
        if (sourceDataObject == null) {
            throw new Exception("\u76ee\u6807\u6570\u636e\u5bf9\u8c61" + targetDataObject.getKey() + "\u6ca1\u6709\u83b7\u53d6\u5230\u6e90\u6570\u636e\u5bf9\u8c61");
        }
        this.sourceDataObject = sourceDataObject;
        this.targetDataObject = targetDataObject;
        this.tableKeys = tableKeys;
        this.vars = vars;
    }

    public void replace() {
        if (this.tableKeys != null && !this.tableKeys.isEmpty()) {
            this.sourceTables = new HashSet();
            String[] v = this.tableKeys.split(",");
            int size = v.length;
            for (int i = 0; i < size; ++i) {
                this.sourceTables.add(v[i]);
            }
        }
        MetaTableCollection sourceTableCollection = this.sourceDataObject.getTableCollection();
        MetaTableCollection targetTableCollection = this.targetDataObject.getTableCollection();
        sourceTableCollection.forEach(metaTable -> {
            String key = metaTable.getKey();
            if (this.sourceTables == null || this.sourceTables.contains(key)) {
                String primaryKey;
                String indexPrefix;
                String parentKey;
                MetaTable newMetaTable = (MetaTable)metaTable.clone();
                newMetaTable.setKey(SimpleStringFormat.format_v2((String)key, this.vars));
                String dbKey = newMetaTable.getDBTableName();
                if (dbKey != null && !dbKey.isEmpty()) {
                    newMetaTable.setDBTableName(SimpleStringFormat.format_v2((String)dbKey, this.vars));
                }
                if ((parentKey = metaTable.getParentKey()) != null && !parentKey.isEmpty()) {
                    newMetaTable.setParentKey(SimpleStringFormat.format_v2((String)parentKey, this.vars));
                }
                if ((indexPrefix = metaTable.getIndexPrefix()) != null && !indexPrefix.isEmpty()) {
                    newMetaTable.setIndexPrefix(SimpleStringFormat.format_v2((String)indexPrefix, this.vars));
                }
                if ((primaryKey = metaTable.getPrimaryKey()) != null && !primaryKey.isEmpty()) {
                    newMetaTable.setPrimaryKey(SimpleStringFormat.format_v2((String)primaryKey, this.vars));
                }
                newMetaTable.forEach(col -> {
                    String refCol = col.getRefCol();
                    if (refCol != null && !refCol.isEmpty()) {
                        col.setRefCol(SimpleStringFormat.format_v2((String)refCol, this.vars));
                    }
                });
                MetaTable targetTable = (MetaTable)targetTableCollection.get(newMetaTable.getKey());
                if (targetTable != null) {
                    newMetaTable.forEach(col -> {
                        if (!targetTable.containsKey(col.getKey())) {
                            targetTable.add((MetaColumn)col.clone());
                        }
                    });
                } else {
                    targetTableCollection.add(newMetaTable);
                }
            }
        });
    }
}

