/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.form.dynamic.MetaDynamicCellLoad;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.MetaExtFormList;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.solution.MetaProject;
import org.json.JSONObject;

public class MetaFormScanLoad
extends BaseMetaScanLoad {
    private MetaFormList formList = null;
    private MetaCellTypeTable cellTypeTable = null;
    private MetaExtFormList extFormList = null;

    public MetaFormScanLoad(MetaFormList formList, MetaCellTypeTable cellTypeTable, IMetaResolver resolver, MetaProject metaProject, Object context) {
        super(resolver, metaProject, "Form", context);
        this.formList = formList;
        this.cellTypeTable = cellTypeTable;
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaFormProfile profile) {
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null) {
            String tagName = profileInfo.optString("TagName");
            if ("Form".equals(tagName)) {
                MetaFormProfile formProfile = new MetaFormProfile();
                formProfile.setKey(profileInfo.optString("Key"));
                formProfile.setCaption(profileInfo.optString("Caption"));
                formProfile.setResource(filePath);
                formProfile.setFormType(FormType.parse((String)profileInfo.optString("FormType")));
                formProfile.setExtend(profileInfo.optString("Extend"));
                formProfile.setMergeToSource(profileInfo.optBoolean("MergeToSource", false));
                formProfile.setProject(this.metaProject);
                formProfile.setPlatform(PlatformType.parse((String)profileInfo.optString("Platform")));
                formProfile.setAliasKey(profileInfo.optString("AliasKey"));
                formProfile.setSourceForm(profileInfo.optString("SourceForm"));
                this.doFind(parent, parentPath, filePath, fileName, formProfile);
                if (formProfile.getFormType() == 9) {
                    if (this.extFormList != null) {
                        if (this.extFormList.containsKey(formProfile.getKey())) {
                            throw new MetaException(20, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatFormDefined"), (Object[])new Object[]{this.metaProject.getKey(), formProfile.getKey()}));
                        }
                        this.extFormList.add(formProfile);
                    }
                } else {
                    if (this.formList.containsKey(formProfile.getKey())) {
                        throw new MetaException(20, SimpleStringFormat.format((String)StringTable.getString(null, "", "RepeatFormDefined"), (Object[])new Object[]{this.metaProject.getKey(), formProfile.getKey()}));
                    }
                    this.formList.add(formProfile);
                }
            } else if ("CellTypeTable".equals(tagName)) {
                MetaDynamicCellLoad load = new MetaDynamicCellLoad(1);
                try {
                    load.load(this.resolver, filePath);
                    MetaCellTypeTable table = (MetaCellTypeTable)load.getRootMetaObject();
                    if (table != null && this.cellTypeTable != null) {
                        this.cellTypeTable.merge(table);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public MetaCellTypeTable getCellTypeTable() {
        return this.cellTypeTable;
    }

    public void setExtFormKeyList(MetaExtFormList extFormList) {
        this.extFormList = extFormList;
    }
}

