/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateList;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateProfile;
import com.bokesoft.yigo.meta.exceltemplate.MetaExcelTemplateSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class MetaExcelTemplateScanLoad
extends BaseMetaScanLoad {
    private MetaExcelTemplateList excelTemplateList = null;
    List<MetaExcelTemplateProfile> list = null;

    public MetaExcelTemplateScanLoad(MetaExcelTemplateList excelTemplateList, IMetaResolver resolver, MetaProject metaProject, Object context) {
        super(resolver, metaProject, "ExcelTemplate", context);
        this.excelTemplateList = excelTemplateList;
        this.list = new CopyOnWriteArrayList<MetaExcelTemplateProfile>();
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.merge();
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        String tagName;
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null && "Workbook".equals(tagName = profileInfo.optString("TagName"))) {
            MetaExcelTemplateProfile profile = new MetaExcelTemplateProfile();
            profile.setKey(profileInfo.optString("Key"));
            profile.setCaption(profileInfo.optString("Caption"));
            profile.setProject(this.metaProject);
            profile.setResource(filePath);
            this.list.add(profile);
        }
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaExcelTemplateProfile profile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge() {
        if (this.list.isEmpty()) {
            return;
        }
        try {
            for (MetaExcelTemplateProfile profile : this.list) {
                String projectKey = profile.getProject().getKey();
                MetaExcelTemplateSubList subList = (MetaExcelTemplateSubList)this.excelTemplateList.get(projectKey);
                if (subList == null) {
                    subList = new MetaExcelTemplateSubList();
                    subList.setKey(projectKey);
                }
                subList.add(profile);
                this.excelTemplateList.add(subList);
            }
        }
        finally {
            this.list.clear();
        }
    }

    public MetaExcelTemplateList getMetaExcelTemplateList() {
        this.merge();
        return this.excelTemplateList;
    }
}

