package com.bokesoft.yigo.meta.util.compext;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;

public class MethodParamTypeUtil {

	/**
	 * 方法参数
	 * 
	 * @param method
	 * @param value
	 * @return
	 */
	public static Object parseMethodPara(Method method, String value) {
		Class<?>[] paraTypes = method.getParameterTypes();
		Class<?> type = paraTypes[0];
		Object paraValue = null;

		if (type == Integer.class || type == int.class) {
			paraValue = Integer.parseInt(value);
		} else if (type == String.class) {
			paraValue = value;
		} else if (type == BigDecimal.class) {
			paraValue = new BigDecimal(value);
		} else if (type == Double.class || type == double.class) {
			paraValue = Double.parseDouble(value);
		} else if (type == Long.class || type == long.class) {
			paraValue = Long.parseLong(value);
		} else if (type == Float.class || type == float.class) {
			paraValue = Float.parseFloat(value);
		} else if (type == Boolean.class || type == boolean.class) {
			paraValue = Boolean.parseBoolean(value);
		} else if (type == Collection.class) {
			String tmpValues[] = value.split(";");
			int tmpLength = tmpValues.length;
			ArrayList<String> listValue = new ArrayList<String>();
			for (int j = 0; j < tmpLength; ++j) {
				listValue.add(tmpValues[j]);
			}
			paraValue = listValue;
		} else if (type == DefSize.class) {
			paraValue = DefSize.parse(value);
		}

		return paraValue;
	}

	/**
	 * 获取metaComponent中的字符串属性值
	 * 
	 * @param metaComponent
	 * @param key
	 * @return
	 */
	public static String getAttrStrValue(MetaForm metaForm, MetaComponent metaComponent, String key) {
		if (key.equalsIgnoreCase(":FormKey")) {
			return metaForm.getKey();
		}

		if (key.equalsIgnoreCase(":ProjectKey")) {
			return metaForm.getProjectKey();
		}

		if (key.equalsIgnoreCase(":FormType")) {
			return FormType.toString(metaForm.getFormType());
		}

		String value = null;

		Method md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getClass().getName(), key.toLowerCase());

		java.lang.Class<?> pClass = FieldAndMethodMap.getInstance()
				.getParseClass(metaComponent.getProperties().getClass().getName(), key.toLowerCase());

		try {
			if (md != null) {
				if (pClass != null) {
					Object v = md.invoke(metaComponent);
					Method m = pClass.getMethod("toString", int.class);
					if (m != null) {
						v = m.invoke(null, v);
						return v.toString();
					}

				} else {
					Object v = md.invoke(metaComponent);

					// v为null时暂不处理
					if (v != null) {
						return v.toString();
					}
				}
			} else {

				md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getProperties().getClass().getName(),
						key.toLowerCase());

				if (md != null) {
					if (pClass != null) {
						Object v = md.invoke(metaComponent.getProperties());
						Method m = pClass.getMethod("toString", int.class);
						if (m != null) {
							v = m.invoke(null, v);
							return v.toString();
						}

					} else {
						Object v = md.invoke(metaComponent.getProperties());

						// v为null时暂不处理
						if (v != null) {
							return v.toString();
						}
					}
				}

			}

		} catch (Throwable e) {
			e.printStackTrace();
		}

		return value;
	}

	/**
	 * 获取metaGridCell中的字符串属性值
	 * 
	 * @param metaComponent
	 * @param key
	 * @return
	 */
	public static String getAttrStrValue(MetaForm metaForm, MetaGridCell metaComponent, String key) {
		if (key.equalsIgnoreCase(":FormKey")) {
			return metaForm.getKey();
		}

		if (key.equalsIgnoreCase(":ProjectKey")) {
			return metaForm.getProjectKey();
		}

		if (key.equalsIgnoreCase(":FormType")) {
			return FormType.toString(metaForm.getFormType());
		}

		String value = null;

		Method md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getClass().getName(), key.toLowerCase());

		java.lang.Class<?> pClass = FieldAndMethodMap.getInstance()
				.getParseClass(metaComponent.getProperties().getClass().getName(), key.toLowerCase());

		try {
			if (md != null) {
				if (pClass != null) {
					Object v = md.invoke(metaComponent);
					Method m = pClass.getMethod("toString", int.class);
					if (m != null) {
						v = m.invoke(null, v);
						return v.toString();
					}

				} else {
					Object v = md.invoke(metaComponent);

					// v为null时暂不处理
					if (v != null) {
						return v.toString();
					}
				}
			} else {

				md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getProperties().getClass().getName(),
						key.toLowerCase());

				if (md != null) {
					if (pClass != null) {
						Object v = md.invoke(metaComponent.getProperties());
						Method m = pClass.getMethod("toString", int.class);
						if (m != null) {
							v = m.invoke(null, v);
							return v.toString();
						}

					} else {
						Object v = md.invoke(metaComponent.getProperties());

						// v为null时暂不处理
						if (v != null) {
							return v.toString();
						}
					}
				}

			}

		} catch (Throwable e) {
			e.printStackTrace();
		}

		return value;
	}

	/**
	 * 获取metaGridCell中的字符串属性值
	 * 
	 * @param metaComponent
	 * @param key
	 * @return
	 */
	public static String getAttrStrValue(MetaForm metaForm, MetaGridRow metaComponent, String key) {
		if (key.equalsIgnoreCase(":FormKey")) {
			return metaForm.getKey();
		}

		if (key.equalsIgnoreCase(":ProjectKey")) {
			return metaForm.getProjectKey();
		}

		if (key.equalsIgnoreCase(":FormType")) {
			return FormType.toString(metaForm.getFormType());
		}

		String value = null;

		Method md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getClass().getName(), key.toLowerCase());

		try {
			if (md != null) {

				Object v = md.invoke(metaComponent);

				// v为null时暂不处理
				if (v != null) {
					return v.toString();
				}
			}

		} catch (Throwable e) {
			e.printStackTrace();
		}

		return value;
	}
}
