package com.bokesoft.yigo.meta.timer.period;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class Moment extends Period {

	public static final String TAG_NAME = "Moment";

	private Integer hour = -1;

	private Integer minute = -1;

	private Integer second = -1;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new Moment();
	}

	public Integer getHour() {
		return hour;
	}

	public void setHour(Integer hour) {
		this.hour = hour;
	}

	public Integer getMinute() {
		return minute;
	}

	public void setMinute(Integer min) {
		this.minute = min;
	}

	public Integer getSecond() {
		return second;
	}

	public void setSecond(Integer second) {
		this.second = second;
	}

	@Override
	public AbstractMetaObject clone() {
		Moment newMoment = (Moment) newInstance();
		newMoment.setHour(hour);
		newMoment.setMinute(minute);
		newMoment.setSecond(second);
		return newMoment;
	}

}
