package com.bokesoft.yigo.meta.taskflow.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaNodeCollection extends GenericKeyCollection<MetaNode> {
	public final static String TAG_NAME = "NodeCollection";
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		MetaNode n = null;
		if ( MetaStart.TAG_NAME.equals(tagName) ) {
			n = new MetaStart();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(n);
			resultMetaObject = n;
		} else if(MetaEnd.TAG_NAME.equals(tagName)) {
			n = new MetaEnd();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(n);
			resultMetaObject = n;
		} else if(MetaFork.TAG_NAME.equals(tagName)) {
			n = new MetaFork();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(n);
			resultMetaObject = n;
		} else if(MetaJoin.TAG_NAME.equals(tagName)) {
			n = new MetaJoin();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(n);
			resultMetaObject = n;
		} else if(MetaTask.TAG_NAME.equals(tagName)) {
			n = new MetaTask();
			n.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(n);
			resultMetaObject = n;	
		}
		return resultMetaObject;
	}

	@Override
	public boolean isStandaloneNode() {
		return false;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNodeCollection();
	}

}
