package com.bokesoft.yigo.meta.taskflow;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

public class MetaTaskFlowProfile extends KeyPairMetaObject {

	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 资源位置 */
	private String resource = null;
	/** 所在工程 */
	private IMetaProject project = null;
	/** 任务流程 */
	private MetaTaskFlow taskFlow = null;
	
	public static final String TAG_NAME = "TaskFlow";

	@Override
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 获取名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 设置任务流程
	 * @param taskFlow 任务流程
	 */
	public void setTaskFlow(MetaTaskFlow taskFlow) {
		this.taskFlow = taskFlow;
	}
	
	/**
	 * 取得任务流程
	 * @return 任务流程
	 */
	public MetaTaskFlow getTaskFlow() {
		return this.taskFlow;
	}
	
	/**
	 * 设置资源路径
	 * @param resource 资源路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源路径
	 * @return 资源路径
	 */
	public String getResource() {
		return this.resource;
	}
	
	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	/**
	 * 取得工程引用
	 * @return 工程引用
	 */
	public IMetaProject getProject() {
		return this.project;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub	
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaTaskFlowProfile clone = new MetaTaskFlowProfile();
		clone.setKey(key);
		clone.setCaption(caption);
		clone.setProject(project);
		clone.setTaskFlow(taskFlow == null ? null : (MetaTaskFlow)taskFlow.clone());
		clone.setResource(resource);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTaskFlowProfile();
	}

}
