package com.bokesoft.yigo.meta.solution;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaStartItem extends KeyPairMetaObject {
	/** 平台标志 */
	private String platform = "";
	/** 启动表单 */
	private String startForm = "";
	/** 登录表单 */
	private String loginForm = "";
	/** APP标志 */
	private String appKey = "";
	
	@Override
	public String getKey() {
		return this.platform + this.appKey;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	public static final String TAG_NAME = "StartItem";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	/**
	 * 设置平台标志
	 * @param platform 平台标志
	 */
	public void setPlatform(String platform) {
		this.platform = platform;
	}
	
	/**
	 * 取得平台标志
	 * @return 平台标志
	 */
	public String getPlatform() {
		return this.platform;
	}
	
	/**
	 * 设置启动表单
	 * @param startForm 启动表单
	 */
	public void setStartForm(String startForm) {
		this.startForm = startForm;
	}
	
	/**
	 * 取得启动表单
	 * @return 启动表单
	 */
	public String getStartForm() {
		return this.startForm;
	}
	

	/**
	 * 设置登录表单
	 * @param loginForm 登录表单
	 */
	public void setLoginForm(String loginForm) {
		this.loginForm = loginForm;
	}
	
	/**
	 * 取得登录表单
	 * @return 登录表单
	 */
	public String getLoginForm() {
		return loginForm;
	}
	
	/**
	 * 设置App标志
	 * @param appKey App标志
	 */
	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}
	/**
	 * 取得App标志
	 * @return App标志
	 */
	public String getAppKey() {
		return appKey;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaStartItem newObject = new MetaStartItem();
		newObject.setPlatform(platform);
		newObject.setStartForm(startForm);
		newObject.setLoginForm(loginForm);
		newObject.setAppKey(appKey);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStartItem();
	}

}
