package com.bokesoft.yigo.meta.solution;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.entry.MetaEntry;

/**
 * MetaProjectProfile类定义工程在解决方案中的属性信息，这里只包含标识和名称，这个定义的目的是为了在应用的工程列表文件中增加工程的条目。
 * @author 王元和
 * @see MetaProject
 */
public class MetaProjectProfile extends KeyPairMetaObject {
	
	private final static String SEP = ",";
	
	/** 工程标识 */
	private String key = null;
	/** 工程名称 */
	private String caption = null;
	/** 对工程元数据的引用 */
	private MetaProject project = null;
	/** 对工程入口元数据的引用 */
	private MetaEntry entry = null;
	/** 工程路径 */
	private String refPath = "";
	/** 差异工程指向 */
	private String diffProject = "";
	private List<String> listDiffSourceProjects = null;
	
	@Override
	public String getKey() {
		return key;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "Project";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		return null;
	}
	
	/**
	 * 设置标识
	 * @param key 取得标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return caption;
	}

	/**
	 * 设置工程元数据
	 * @param project 工程元数据
	 */
	public void setProject(MetaProject project) {
		this.project = project;
		if (this.project != null && this.isDiffProject()) {
			this.project.setAsDiffProject();
		}
	}
	
	/** 取得工程元数据
	 * @return 工程定义
	 */
	public MetaProject getProject() {
		return project;
	}
	
	/**
	 * 设置入口元数据
	 * @param entry 入口元数据
	 */
	public void setEntry(MetaEntry entry) {
		this.entry = entry;
		if(this.entry != null) {
			this.entry.setProject(this.getKey());
		}
	}
	
	/**
	 * 取得入口元数据
	 * @return 入口元数据
	 */
	public MetaEntry getEntry() {
		return this.entry;
	}
	
	public String getRefPath() {
		return refPath;
	}

	public void setRefPath(String refPath) {
		this.refPath = refPath;
	}
	
	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}	

	/**
	 * 设置差异工程
	 * @param diffProject
	 */
	public void setDiffProject(String diffProject) {
		this.diffProject = diffProject;
		if (this.project != null) {
			project.setDiffProject(diffProject);
		}
	}
	
	/**
	 * 获取差异工程
	 * @return
	 */
	public String getDiffProject() {
		return this.diffProject;
	}

	/**
	 * 是否是差异工程
	 * @return
	 */
	public boolean isDiffProject() {
		return listDiffSourceProjects != null && listDiffSourceProjects.size() > 0;
	}
	
	/**
	 * 获取差异工程指向的原工程
	 * 
	 * @return
	 */
	public String getDiffSourceProjects() {
		if (listDiffSourceProjects == null) {
			return "";
		}
		return StringUtil.join(SEP, listDiffSourceProjects.iterator());
	}
	
	/**
	 * 设置差异工程指向的原工程
	 * 
	 * @param sDiffSourceProjects
	 */
	public void setDiffSourceProjects(String sDiffSourceProjects) {
		if (!StringUtil.isBlankOrNull(sDiffSourceProjects)) {
			String[] arrDiffSourceProjects = StringUtil.split(sDiffSourceProjects, SEP);
			if (listDiffSourceProjects != null) listDiffSourceProjects.clear();
			for (String sDiffSourceProject : arrDiffSourceProjects) {
				addDiffSourceProject(sDiffSourceProject);
			}
		}
	}
	
	/**
	 * 获取差异工程指向的原工程列表
	 * 
	 * @return
	 */
	public List<String> getDiffSourceProjectList() {
		return this.listDiffSourceProjects;
	}
	
	/**
	 * 添加差异工程包含的原工程
	 * 
	 * @param diffSourceProject
	 */
	public void addDiffSourceProject(String diffSourceProject) {
		if (listDiffSourceProjects == null) {
			listDiffSourceProjects = new ArrayList<>();
		}
		listDiffSourceProjects.add(diffSourceProject);
	}
}
