package com.bokesoft.yigo.meta.setting;

/**
 * 数据簇划分类型，定义操作员与数据簇的对应关系
 * 
 * @author 王元和
 *
 */
public class ClusterType {
	/** 一对一 */
	public static final int One2One = 0;
	public static final String STR_One2One = "One2One";

	/** 一对多 */
	public static final int One2Set = 1;
	public static final String STR_One2Set = "One2Set";

	/** 集群拆分 */
	public static final int DBSplit = 2;
	public static final String STR_DBSplit = "DBSplit";


	public static int parse(String s) {
		int type = -1;
		if (STR_One2One.equalsIgnoreCase(s)) {
			type = One2One;
		} else if (STR_One2Set.equalsIgnoreCase(s)) {
			type = One2Set;
		} else if (STR_DBSplit.equalsIgnoreCase(s)) {
			type = DBSplit;
		}
		return type;
	}

	public static String toString(Integer type) {
		if(type == null)
			return "";
		
		String s = null;
		switch (type) {
		case One2One:
			s = STR_One2One;
			break;
		case One2Set:
			s = STR_One2Set;
			break;
		case DBSplit:
			s = STR_DBSplit;
			break;
		}
		return s;
	}
}
