package com.bokesoft.yigo.meta.search;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 使用ElasticSearch优化模糊查询时，需要用到的配置
 * 
 * @author yuanye
 *
 */

public class MetaElasticSearch extends GenericKeyCollection<MetaElasticSearchDict> {

	public final static String TAG_NAME ="ElasticSearch";

	public final static String INDEX_NAME = "indexName";
	
	public final static String HOST = "host";
	
	public final static String CLUSTER_NAME = "clusterName";

	
	/**
	 * ElasticSearch（简称ES）的集群名
	 */
	private String clusterName = null;
	
	/**
	 * 连接ES集群中的一个机器
	 */
	private String host = null;
	
	private String indexName = null;
	
	public void setClusterName(String clusterName){
		this.clusterName=clusterName;
	}
	
	public String getClusterName(){
		return this.clusterName;
	}
	
	public void setHost(String host){
		this.host=host;
	}
	
	public String getHost(){
		return this.host;
	}
	
	public void setIndexName(String indexName){
		this.indexName=indexName;
	}
	
	public String getIndexName(){
		return this.indexName;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaElasticSearchDict.TAG_NAME)) {
			resultMetaObject = new MetaElasticSearchDict();
		} else
			return null;

		resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		add((MetaElasticSearchDict) resultMetaObject);
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
}
