package com.bokesoft.yigo.meta.report.embed.chart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaReportChartDataSource extends AbstractMetaObject {
	/** 绑定的数据源标识，如果来源于组件，则为组件的标识，如果来源于数据对象，则为表的标识 */
	private String bindingKey = "";
	private List<MetaReportSeries> seriesArray = null;
	private MetaReportCategory category = null;
	public MetaReportChartDataSource() {
		super();
		seriesArray = new ArrayList<MetaReportSeries>();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(seriesArray);
		if ( category != null ) {
			list.add(category);
		}
	}
	
	public static final String TAG_NAME = "ChartDataSource";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	public void setSeriesArray(List<MetaReportSeries> seriesArray) {
		this.seriesArray = seriesArray;
	}
	
	public List<MetaReportSeries> getSeriesArray() {
		return this.seriesArray;
	}
	
	public void setCategory(MetaReportCategory category) {
		this.category = category;
	}
	
	public MetaReportCategory getCategory() {
		return this.category;
	}
	
	public void setBindingKey(String bindingKey) {
		this.bindingKey = bindingKey;
	}
	
	public String getBindingKey() {
		return this.bindingKey;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaReportSeries.TAG_NAME.equals(tagName) ) {
			MetaReportSeries metaSeries = new MetaReportSeries();
			seriesArray.add(metaSeries);
			resultMetaObject = metaSeries;
		} else if ( MetaReportCategory.TAG_NAME.equals(tagName) ) {
			category = new MetaReportCategory();
			resultMetaObject = category;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaReportChartDataSource newObject = new MetaReportChartDataSource();
		newObject.setBindingKey(bindingKey);
		ArrayList<MetaReportSeries> newSeriesArray = new ArrayList<MetaReportSeries>();
		Iterator<MetaReportSeries> it = seriesArray.iterator();
		MetaReportSeries series = null;
		while ( it.hasNext() ) {
			series = it.next();
			newSeriesArray.add((MetaReportSeries)series.clone());
		}
		newObject.setSeriesArray(newSeriesArray);
		newObject.setCategory(category == null ? null : (MetaReportCategory)category.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportChartDataSource();
	}

}
