package com.bokesoft.yigo.meta.report.embed;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.ChartType;
import com.bokesoft.yigo.common.def.EChartRenderType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartDataSource;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportChartDataSource;

public class MetaReportChart extends MetaReportEmbedObject {
	
	public static final String TAG_NAME = "Chart";
	
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	
	/**
	 * 图表类型，取值见{@link com.bokesoft.yigo.common.def.ChartType}
	 */
	private Integer chartType = ChartType.Line;
	/** 图表的标题 */
	private String title = "";
	/** 系列在行标志 */
	private Boolean seriesInRow = false;
	/** 系列轴标题 */
	private String seriesAxisTitle = "";
	/** 项目轴标题 */
	private String categoryAxisTitle = "";
	/** 图表数据源定义 */
	private MetaReportChartDataSource dataSource = null;
	/** 是否显示值*/
	private Boolean showValue = true;
	/** 是否填满内部，仅雷达图使用*/
	private Boolean fill = false;
	
	private EChartRenderType renderType = EChartRenderType.Draw;
	
	public MetaReportChart() {
		super();
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	
	/**
	 * 设置图表类型
	 * @param chartType 图表类型
	 */
	public void setChartType(Integer chartType) {
		this.chartType = chartType;
	}
	
	/**
	 * 取得图表类型
	 * @return 图表类型
	 */
	public Integer getChartType() {
		return this.chartType;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getTitle() {
		return this.title;
	}
	
	public void setSeriesInRow(Boolean seriesInRow) {
		this.seriesInRow = seriesInRow;
	}
	
	public Boolean getSeriesInRow() {
		return this.seriesInRow;
	}
	
	public void setSeriesAxisTitle(String seriesAxisTitle) {
		this.seriesAxisTitle = seriesAxisTitle;
	}
	
	public String getSeriesAxisTitle() {
		return this.seriesAxisTitle;
	}
	
	public void setCategoryAxisTitle(String categoryAxisTitle) {
		this.categoryAxisTitle = categoryAxisTitle;
	}
	
	public String getCategoryAxisTitle() {
		return this.categoryAxisTitle;
	}
	
	public void setDataSource(MetaReportChartDataSource dataSource) {
		this.dataSource = dataSource;
	}
	
	public MetaReportChartDataSource getDataSource() {
		return this.dataSource;
	}
	
	public Boolean isShowValue() {
		return showValue;
	}

	public void setShowValue(Boolean showValues) {
		this.showValue = showValues;
	}

	public Boolean isFill() {
		return fill;
	}

	public void setFill(Boolean fill) {
		this.fill = fill;
	}
	
	public void setRenderType(EChartRenderType renderType) {
		this.renderType = renderType;
	}
	
	public EChartRenderType getRenderType() {
		return this.renderType;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new Object[] {
			dataSource
		});
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaChartDataSource.TAG_NAME.equals(tagName) ) {
			dataSource = new MetaReportChartDataSource();
			resultMetaObject = dataSource;
		}
		return resultMetaObject;
	}
	
	@Override
	public int getCompositeType() {
		return ReportEmbedType.Chart;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		MetaReportChart newChart = new MetaReportChart();
		newChart.setX(super.getX());
		newChart.setY(super.getY());
		newChart.setWidth(super.getWidth());
		newChart.setHeight(super.getHeight());
		
		newChart.setChartType(chartType);
		newChart.setTitle(title);
		newChart.setSeriesInRow(seriesInRow);
		newChart.setSeriesAxisTitle(seriesAxisTitle);
		newChart.setCategoryAxisTitle(categoryAxisTitle);
		newChart.setDataSource(dataSource == null ? null : (MetaReportChartDataSource) dataSource.clone());
		newChart.setShowValue(showValue);
		newChart.setFill(fill);

		newChart.setKey(key);
		newChart.setCaption(caption);
		return newChart;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaReportChart();
	}

}
