package com.bokesoft.yigo.meta.permission.filter;

import java.util.LinkedList;

import com.bokesoft.yigo.common.def.PermissionFilterStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaFilter extends AbstractMetaObject {
	
	public static final String TAG_NAME = "Filter";
	/** 服务ID*/
	private String serviceID = null;
	
	/** 采用的过滤方式*/
	private Integer style = PermissionFilterStyle.PERMISSION;
	
	/** 自定义过滤类的全路径名*/
	private String impl = "";
	
	/** 当过滤方式为mapping时，过滤的定义*/
	private MetaMappingFilter mapFilter = null;


	public Integer getStyle() {
		return style;
	}

	public void setStyle(Integer style) {
		this.style = style;
	}

	public String getImpl() {
		return impl;
	}

	public void setImpl(String impl) {
		this.impl = impl;
	}

	public MetaMappingFilter getMapFilter() {
		return mapFilter;
	}

	public void setMapFilter(MetaMappingFilter mapFilter) {
		this.mapFilter = mapFilter;
	}

	public String getServiceID() {
		return serviceID;
	}

	public void setServiceID(String serviceID) {
		this.serviceID = serviceID;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll2(list, mapFilter);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaMappingFilter.TAG_NAME.equals(tagName)) {
			mapFilter = new MetaMappingFilter();
			child = mapFilter;
		}
		return child;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaFilter newObj = new MetaFilter();
		newObj.serviceID = serviceID;
		newObj.style = style;
		newObj.impl = impl;
		newObj.mapFilter = mapFilter == null ? null : (MetaMappingFilter)mapFilter.clone();
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFilter();
	}

}
