package com.bokesoft.yigo.meta.path.relation;

import java.io.InputStream;
import org.xml.sax.Attributes;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomSAXReader;
import com.bokesoft.yigo.common.dom.IDomSAXReaderListener;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaRelationPartScanLoad extends BaseMetaScanLoad {

	private MetaRelationPartList partList = null;
	
	private int runType = AppRunType.App;
	public MetaRelationPartScanLoad(MetaRelationPartList relationPartList, IMetaResolver resolver, MetaProject metaProject, Object context, int runtype) {
		super(resolver, metaProject, DomMetaConstants.RELATIONCHECK_FOLD, context);
		this.partList = relationPartList;
		this.runType = runtype;
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		// TODO Auto-generated method stub

		DomSAXReader reader = new DomSAXReader(parent, new IDomSAXReaderListener() {

			@Override
			public void startElement(Object parent, String resource, String uri, String localName, String qName, Attributes attributes) {
				if (MetaRelationPart.TAG_NAME.equals(qName)) {
					MetaRelationPartProfile profile = new MetaRelationPartProfile();
					profile.setKey(attributes.getValue(MetaConstants.COMMON_KEY));
					profile.setCaption(attributes.getValue(MetaConstants.COMMON_CAPTION));

					profile.setProject(metaProject);
					profile.setResource(resource);

					String str = profile.getKey();
					if (partList.containsKey(str)) {
						throw new MetaException(MetaException.REPEAT_DATAOBJECT_DEFINED, SimpleStringFormat.format(StringTable.getString(null, "", StringTable.RepeatDataObjectDefined), metaProject.getKey(), "", profile.getKey()));
					}
					doFind(parent, parentPath, filePath, fileName, profile);
					partList.add(profile);
				}
			}

			@Override
			public boolean stopParse(boolean startElement, String tagName) {
				return true;
			}

			@Override
			public void endElement(String uri, String localName, String qName) {
			}
		});
		InputStream in = resolver.read(filePath, 0);
		try {
			reader.start(in, filePath);
		} finally {
			if (in != null) {
				in.close();
			}
		}
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaRelationPartProfile profile) {

	}

}
