package com.bokesoft.yigo.meta.paratable;

import java.util.LinkedList;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaParaTable extends GenericKeyCollection<MetaParaGroup> implements IPropertyMerger<MetaParaTable> {

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	public static final String TAG_NAME = "ParaTable";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaParaGroup.TAG_NAME.equals(tagName) ) {
			MetaParaGroup group = new MetaParaGroup();
			group.preProcessMetaObject(env, doc, node, flag, runType);
			if ( this.containsKey(group.getKey()) ) {
				throw new MetaException(MetaException.REPEAT_PARA_GROUP_DEFINED, SimpleStringFormat.format(
						StringTable.getString(null, "", StringTable.RepeatParaGroupDefined),  group.getKey()));
			}
			this.add(group);
			resultMetaObject = group;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaParaTable();
	}
	public boolean needPreLoad() {
		return true;
	}
	@Override
	public void merge(MetaParaTable metaParaGroups) {
		if ( metaParaGroups != null ) {
			for (MetaParaGroup metaParaGroup : metaParaGroups) {
				if (this.containsKey(metaParaGroup.getKey())){
					this.get(metaParaGroup.getKey()).merge(metaParaGroup);
				} else {
					this.add(metaParaGroup);
				}
			}
		}

	}
}
