package com.bokesoft.yigo.meta.paratable;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaParaItem extends KeyPairMetaObject implements IPropertyMerger<MetaParaItem> {
	/** 标识 */
	private String key = "";
	/** 名称 */
	private String caption = "";
	/** 值 */
	private String value = "";
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Item";
	
	@Override
	public String getTagName() { 
		return TAG_NAME;
	}
	
	/**
	 * 设置标识
	 * @param key 标识
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 取得标识
	 * @return 标识
	 */
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置名称
	 * @param caption 名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得名称
	 * @return 名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置值
	 * @param value 值
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/**
	 * 取得值
	 * @return 值
	 */
	public String getValue() {
		return this.value;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaParaItem newObject = (MetaParaItem)newInstance();
		newObject.setKey(key);
		newObject.setCaption(caption);
		newObject.setValue(value);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaParaItem();
	}

	@Override
	public void merge(MetaParaItem metaParaItem) {
//		if (metaParaItem.getValue() == null) {
			value = metaParaItem.getValue();
//		}
		if (metaParaItem.getCaption() == null) {
			caption = metaParaItem.getCaption();
		}
	}
}
