package com.bokesoft.yigo.meta.mapping;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public abstract class MetaNode extends AbstractMapElement {
	
	protected MetaRelationCollection relationCollection = null;
	
	private Boolean joinPrimary = false;

	public Boolean isJoinPrimary() {
		return joinPrimary;
	}

	public MetaRelationCollection getRelationCollection() {
		return relationCollection;
	}

	public void setJoinPrimary(Boolean joinPrimary) {
		this.joinPrimary = joinPrimary;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll2(list, relationCollection);
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (MetaRelationCollection.TAG_NAME.equals(tagName)) {
			relationCollection = new MetaRelationCollection();
			child = relationCollection; 
		}
		return child;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaNode newObj = (MetaNode)super.clone();
		newObj.joinPrimary = joinPrimary;
		newObj.relationCollection = (relationCollection == null ? null : (MetaRelationCollection)relationCollection.clone());
		return newObj;
	}

}
