package com.bokesoft.yigo.meta.form.component.view.overrides;

/**
 * OverridesType定义属性覆盖定义对象的类型
 * 
 * @author wangyh
 *
 */
public class OverridesType {
	/** 组件 */
	public static final int Component = 1;
	public static final String Str_Component = "Component";
	/** 列表 */
	public static final int ListView = 2;
	public static final String Str_ListView = "ListView";
	/** 网格 */
	public static final int Grid = 3;
	public static final String Str_Grid = "Grid";
	/** TableView */
	public static final int TableView = 4;
	public static final String Str_TableView = "TableView";

	public static int parse(String typeStr) {
		int type = -1;
		if (typeStr.equals(Str_Component)) {
			type = Component;
		} else if (typeStr.equals(Str_ListView)) {
			type = ListView;
		} else if (typeStr.equals(Str_Grid)) {
			type = Grid;
		} else if (typeStr.equals(Str_TableView)) {
			type = TableView;
		}
		return type;
	}

	public static String toString(int type) {
		switch (type) {
		case Component:
			return Str_Component;
		case ListView:
			return Str_ListView;
		case Grid:
			return Str_Grid;
		case TableView:
			return Str_TableView;
		default:
			break;
		}
		return "";
	}
}
