package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaWizardLayout extends MetaComponentLayout<MetaLayoutWizardItem>{
	
	@Override
	public int getLayoutType() {
		return LayoutType.LAYOUT_WIZARD;
	}

	public static final String TAG_NAME = "WizardLayout";
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaWizardLayout();
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaLayoutWizardItem.TAG_NAME.equals(tagName) ) {
			MetaLayoutWizardItem item = new MetaLayoutWizardItem();
			item.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(item);
			resultMetaObject = item;
		}
		if (resultMetaObject == null) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

}
