package com.bokesoft.yigo.meta.form.component.panel.tablepanel;

import java.util.Iterator;
import java.util.LinkedList;

import com.bokesoft.yes.common.struct.StringHashSet;
import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumnCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRowIndex;

public class MetaFluidTableLayoutPanel extends MetaPanel {
	/** 排列的重复数 */
	private Integer repeatCount = 1;
	/** 排列的间距 */
	private Integer repeatGap = 0;
	/** 行间距 */
	private Integer rowGap = 0;
	/** 列间距 */
	private Integer columnGap = 0;
	/** 默认行高 */
	private Integer rowHeight = 20;
	/** 列定义 */
	private MetaTableColumnCollection columnCollection = null;
	
	public MetaFluidTableLayoutPanel() {
		super();
		columnCollection = new MetaTableColumnCollection();
	}
	
	public static final String TAG_NAME = ControlType.STR_FLUIDTABLELAYOUTPANEL;
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.FLUIDTABLELAYOUTPANEL;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		super.getChildMetaObjects(list);
		addAll(list, new AbstractMetaObject[] { columnCollection });
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node,
			String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaTableColumnCollection.TAG_NAME.equals(tagName) ) {
			columnCollection = new MetaTableColumnCollection();
			resultMetaObject = columnCollection;
		}
		if ( resultMetaObject == null ) {
			resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		}
		return resultMetaObject;
	}

	public void setColumnCollection(MetaTableColumnCollection columnCollection) {
		this.columnCollection = columnCollection;
	}
	
	public MetaTableColumnCollection getColumnCollection() {
		return this.columnCollection;
	}
	
	public void setRepeatCount(Integer repeatCount) {
		this.repeatCount = repeatCount;
	}
	
	public Integer getRepeatCount() {
		return this.repeatCount;
	}
	
	public void setRepeatGap(Integer repeatGap) {
		this.repeatGap = repeatGap;
	}
	
	public Integer getRepeatGap() {
		return this.repeatGap;
	}
	
	public void setRowGap(Integer rowGap) {
		this.rowGap = rowGap;
	}
	
	public Integer getRowGap() {
		return this.rowGap;
	}
	
	public void setColumnGap(Integer columnGap) {
		this.columnGap = columnGap;
	}
	
	public Integer getColumnGap() {
		return this.columnGap;
	}
	
	public void setRowHeight(Integer rowHeight) {
		this.rowHeight = rowHeight;
	}
	
	public Integer getRowHeight() {
		return this.rowHeight;
	}

	@Override
	public AbstractMetaObject getProperties() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaFluidTableLayoutPanel newObject = (MetaFluidTableLayoutPanel)super.clone();
		newObject.setRepeatCount(repeatCount);
		newObject.setRepeatGap(repeatGap);
		newObject.setRowGap(rowGap);
		newObject.setColumnGap(columnGap);
		newObject.setRowHeight(rowHeight);
		newObject.setColumnCollection(columnCollection == null ? null : (MetaTableColumnCollection)columnCollection.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaFluidTableLayoutPanel();
	}

	@Override
	public MetaFluidTableLayout newLayout() {
		MetaFluidTableLayout layout = new MetaFluidTableLayout();
		MetaLayoutColumnCollection layoutColumnCollection = new MetaLayoutColumnCollection();
		Iterator<MetaTableColumn> itColumn = this.columnCollection.iterator();
		while ( itColumn.hasNext() ) {
			MetaTableColumn tableColumn = itColumn.next();
			MetaLayoutColumn layoutColumn = new MetaLayoutColumn();
			layoutColumn.setWidth(tableColumn.getWidth());
			layoutColumnCollection.add(layoutColumn);
		}
		layout.setKey(key);
		layout.setColumnCollection(layoutColumnCollection);
		layout.setRowHeight(rowHeight);
		layout.setRepeatCount(repeatCount);
		layout.setRepeatGap(repeatGap);
		layout.setRowGap(rowGap);
		layout.setColumnGap(columnGap);
		
		// 第一遍建立伙伴组件的集合，伙伴组件不能加到布局信息中
		StringHashSet buddySet = new StringHashSet();
		Iterator<MetaComponent> itComponent = this.iteratorComponent();
		MetaComponent component = null;
		while ( itComponent.hasNext() ) {
			component = itComponent.next();
			String buddyKey = component.getBuddyKey();
			if ( buddyKey != null && !buddyKey.isEmpty() ) {
				buddySet.add(buddyKey);
			}
		}
		
		itComponent = this.iteratorComponent();
		while ( itComponent.hasNext() ) {
			component = itComponent.next();
			if ( !buddySet.contains(component.getKey()) ) {
				MetaLayoutRowIndex layoutRowIndex = new MetaLayoutRowIndex();
				layoutRowIndex.setKey(component.getKey());
				layout.add(layoutRowIndex);
			}
		}
		
		return layout;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (columnCollection.size() < 2) {
			throw new MetaException(MetaException.MISS_COLUMN_DEFINITION, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.MissColumnDefinition), this.getKey()));
		}
	}
	
	@Override
	public void merge(MetaComponent meta) {
		super.merge(meta);
		
		MetaFluidTableLayoutPanel metaPanel = (MetaFluidTableLayoutPanel)meta;
		
		if( this.repeatCount == -1 ) {
			this.repeatCount = metaPanel.getRepeatCount();
		}
		if( this.repeatGap == -1 ) {
			this.repeatGap = metaPanel.getRepeatGap();
		}
		if( this.rowGap == -1 ) {
			this.rowGap = metaPanel.getRepeatGap();
		}
		if( this.columnGap == -1 ) {
			this.columnGap = metaPanel.getColumnGap();
		}
		if( this.rowHeight == -1 ) {
			this.rowHeight = metaPanel.getRowHeight();
		}
		
	}
}
